/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.pull;

import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestActivity;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestRescopeDetails;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;

@JsonSerialize
@JsonSurrogate(value=PullRequestRescopeActivity.class)
public class RestPullRequestRescopeActivity
extends RestPullRequestActivity {
    private static final String ADDED = "added";
    private static final String FROM_HASH = "fromHash";
    private static final String PREVIOUS_FROM_HASH = "previousFromHash";
    private static final String PREVIOUS_TO_HASH = "previousToHash";
    private static final String REMOVED = "removed";
    private static final String TO_HASH = "toHash";

    public RestPullRequestRescopeActivity(PullRequestRescopeActivity activity) {
        this(activity.getId(), activity.getCreatedDate(), new RestApplicationUser(activity.getUser()), activity.getAction(), activity.getFromHash(), activity.getPreviousFromHash(), activity.getPreviousToHash(), activity.getToHash(), new RestRescopeDetails(activity.getAdded()), new RestRescopeDetails(activity.getRemoved()));
    }

    private RestPullRequestRescopeActivity(long id, Date createdDate, RestApplicationUser user, PullRequestAction action, String fromHash, String previousFromHash, String previousToHash, String toHash, RestRescopeDetails addedRescopeDetails, RestRescopeDetails removedRescopeDetails) {
        super(id, createdDate, user, action);
        this.put(FROM_HASH, fromHash);
        this.put(PREVIOUS_FROM_HASH, previousFromHash);
        this.put(PREVIOUS_TO_HASH, previousToHash);
        this.put(TO_HASH, toHash);
        this.put(ADDED, (Object)addedRescopeDetails);
        this.put(REMOVED, (Object)removedRescopeDetails);
    }

    public RestRescopeDetails getAdded() {
        return (RestRescopeDetails)((Object)this.get(ADDED));
    }

    @Schema(example="abcdeabcdeabcdeabcdeabcdeabcdeabcdeabcde")
    public String getFromHash() {
        return this.getStringProperty(FROM_HASH);
    }

    @Schema(example="cdeabcdeabcdeabcdeabcdeabcdeabcdeabcdeab")
    public String getPreviousFromHash() {
        return this.getStringProperty(PREVIOUS_FROM_HASH);
    }

    @Schema(example="ddeabcdeabcdeabcdeabcdeabcdeabcdeabcdeabc")
    public String getPreviousToHash() {
        return this.getStringProperty(PREVIOUS_TO_HASH);
    }

    public RestRescopeDetails getRemoved() {
        return (RestRescopeDetails)((Object)this.get(REMOVED));
    }

    @Schema(example="bcdeabcdeabcdeabcdeabcdeabcdeabcdeabcdea")
    public String getToHash() {
        return this.getStringProperty(TO_HASH);
    }
}

