/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.deployment;

import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.bitbucket.dmz.rest.v2.deployment.RestDeploymentEnvironment;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.commit.RestMinimalCommit;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonSerialize
@JsonSurrogate(value=Deployment.class)
public class RestDeployment
extends RestMapEntity {
    private static final String DEPLOYMENT_SEQUENCE_NUMBER = "deploymentSequenceNumber";
    private static final String DESCRIPTION = "description";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ENVIRONMENT = "environment";
    private static final String FROM_COMMIT = "fromCommit";
    private static final String KEY = "key";
    private static final String LAST_UPDATED = "lastUpdated";
    private static final String REPOSITORY = "repository";
    private static final String STATE = "state";
    private static final String TO_COMMIT = "toCommit";
    private static final String URL = "url";

    public RestDeployment() {
    }

    public RestDeployment(@Nonnull Deployment deployment) {
        this(deployment.getDeploymentSequenceNumber(), deployment.getDescription(), deployment.getDisplayName(), new RestDeploymentEnvironment(deployment.getEnvironment()), deployment.getFromCommit().map(RestMinimalCommit.REST_TRANSFORM).orElse(null), deployment.getKey(), deployment.getLastUpdated(), (RestRepository)RestRepository.REST_TRANSFORM.apply(deployment.getRepository()), deployment.getState(), (RestMinimalCommit)RestMinimalCommit.REST_TRANSFORM.apply(deployment.getToCommit()), deployment.getUrl().toASCIIString());
    }

    private RestDeployment(Map<String, Object> values) {
        super(values);
    }

    private RestDeployment(long deploymentSequenceNumber, @Nonnull String description, @Nonnull String displayName, @Nonnull RestDeploymentEnvironment environment, RestMinimalCommit fromCommit, @Nonnull String key, @Nonnull Date lastUpdated, @Nonnull RestRepository repository, @Nonnull DeploymentState state, @Nonnull RestMinimalCommit toCommit, @Nonnull String url) {
        this.put(DEPLOYMENT_SEQUENCE_NUMBER, deploymentSequenceNumber);
        this.put(DESCRIPTION, description);
        this.put(DISPLAY_NAME, displayName);
        this.put(ENVIRONMENT, (Object)environment);
        this.put(FROM_COMMIT, fromCommit);
        this.put(KEY, key);
        this.put(LAST_UPDATED, lastUpdated.getTime());
        this.put(REPOSITORY, repository);
        this.put(STATE, state);
        this.put(TO_COMMIT, toCommit);
        this.put(URL, url);
    }

    @Nullable
    public static RestDeployment valueOf(Object value) {
        if (value instanceof RestDeployment) {
            return (RestDeployment)((Object)value);
        }
        if (value instanceof Map) {
            return new RestDeployment((Map)value);
        }
        return null;
    }

    @Schema(example="5")
    public long getDeploymentSequenceNumber() {
        return this.getLongProperty(DEPLOYMENT_SEQUENCE_NUMBER);
    }

    @Nonnull
    @Schema(example="Production and mirror environments")
    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    @Nonnull
    @Schema(example="US East Mirror")
    public String getDisplayName() {
        return this.getStringProperty(DISPLAY_NAME);
    }

    @Nonnull
    public RestDeploymentEnvironment getEnvironment() {
        return RestDeploymentEnvironment.valueOf(this.get(ENVIRONMENT));
    }

    @Nullable
    public RestMinimalCommit getFromCommit() {
        return RestMinimalCommit.valueOf((Object)this.get(FROM_COMMIT));
    }

    @Schema(example="PROD-MIR")
    @Nonnull
    public String getKey() {
        return this.getStringProperty(KEY);
    }

    @Schema(example="1449075920")
    @Nonnull
    public long getLastUpdated() {
        return this.getLongProperty(LAST_UPDATED);
    }

    @Nonnull
    public RestRepository getRepository() {
        return RestRepository.valueOf((Object)this.get(REPOSITORY));
    }

    @Nonnull
    public DeploymentState getState() {
        return (DeploymentState)this.getEnumProperty(STATE, DeploymentState.class);
    }

    @Nonnull
    public RestMinimalCommit getToCommit() {
        return RestMinimalCommit.valueOf((Object)this.get(TO_COMMIT));
    }

    @Schema(example="http://example.ci.org/projects/PROJ/deploy/mirror-deploy/100")
    public String getUrl() {
        return this.getStringProperty(URL);
    }
}

