/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.util;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.util.NamedLink;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonSerialize
public class RestNamedLink
extends RestMapEntity
implements NamedLink {
    public static final String ATTR_HREF = "href";
    public static final String ATTR_NAME = "name";
    public static final Function<NamedLink, RestNamedLink> REST_TRANSFORM = RestNamedLink::new;

    public RestNamedLink(@Nonnull String href) {
        this(href, null);
    }

    public RestNamedLink(@Nonnull String href, @Nullable String name) {
        this.put(ATTR_HREF, href);
        this.putIfNotNull(ATTR_NAME, name);
    }

    public RestNamedLink(@Nonnull NamedLink link) {
        this(link.getHref(), link.getName());
    }

    public RestNamedLink(@Nonnull Map<String, Object> map) {
        super(map);
    }

    @Nullable
    public static RestNamedLink valueOf(@Nullable Object link) {
        if (link instanceof RestNamedLink) {
            return (RestNamedLink)link;
        }
        if (link instanceof NamedLink) {
            return new RestNamedLink((NamedLink)link);
        }
        if (link instanceof Map) {
            return new RestNamedLink((Map)link);
        }
        return null;
    }

    @Schema(example="https://bitbucket.example.com/scm/awesomeproject/awesomerepo.git")
    @Nonnull
    public String getHref() {
        return this.getStringProperty(ATTR_HREF);
    }

    @Schema(example="http")
    @Nonnull
    public String getName() {
        return this.getStringProperty(ATTR_NAME);
    }
}

