/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.enrich;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.Page;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.WebApplicationException;

public final class EnrichProcessor {
    @Nonnull
    public static Object processEntities(@Nonnull Object entity, @Nonnull Function<Object, Object> processCallback) {
        Collection entities;
        Objects.requireNonNull(processCallback, "processCallback");
        if (entity instanceof JsonStreamingOutput) {
            return EnrichProcessor.processStreamingOutput((JsonStreamingOutput)entity, processCallback);
        }
        if ((entity = processCallback.apply(entity)) instanceof Page) {
            entities = ((Page)entity).getValues();
        } else if (entity instanceof Iterable) {
            entities = (Iterable)entity;
        } else if (entity instanceof RestMapEntity) {
            entities = ((RestMapEntity)entity).values();
        } else {
            return entity;
        }
        for (Object o : entities) {
            EnrichProcessor.processEntities(o, processCallback);
        }
        return entity;
    }

    private static JsonStreamingOutput processStreamingOutput(final @Nonnull JsonStreamingOutput output, final @Nonnull Function<Object, Object> processCallback) {
        Objects.requireNonNull(output, "output");
        Objects.requireNonNull(processCallback, "processCallback");
        return new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                output.write(writer.transform(input -> EnrichProcessor.processEntities(input, processCallback)));
            }
        };
    }
}

