/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.content;

import com.atlassian.bitbucket.content.DiffSegment;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiffLine;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=DiffSegment.class)
public class RestDiffSegment
extends RestMapEntity {
    public static final Function<DiffSegment, RestDiffSegment> REST_TRANSFORM = RestDiffSegment::new;
    private static final String LINES = "lines";
    private static final String TRUNCATED = "truncated";
    private static final String TYPE = "type";

    public RestDiffSegment() {
    }

    public RestDiffSegment(DiffSegment segment) {
        this(segment.getType(), RestDiffSegment.transform(segment.getLines(), RestDiffLine.REST_TRANSFORM), segment.isTruncated());
    }

    private RestDiffSegment(DiffSegmentType type, List<RestDiffLine> lines, boolean truncated) {
        this.putIfNotNull(TYPE, type);
        this.putIfNotNull(LINES, lines);
        this.putIfNotNull(TRUNCATED, truncated);
    }

    @ArraySchema(schema=@Schema(implementation=RestDiffLine.class))
    public List<RestDiffLine> getLines() {
        return (List)this.get(LINES);
    }

    public DiffSegmentType getType() {
        return this.getEnumProperty(TYPE, DiffSegmentType.class);
    }

    public boolean isTruncated() {
        return this.getBoolProperty(TRUNCATED);
    }
}

