/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.comment;

import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

@JsonSerialize
public class RestMultilineCommentMarker
extends RestMapEntity {
    public static final String START_LINE = "startLine";
    public static final String START_LINE_TYPE = "startLineType";

    public RestMultilineCommentMarker(Map<String, Object> values) {
        this.putAll(values);
    }

    public RestMultilineCommentMarker(int startLine, @Nonnull DiffSegmentType startLineType) {
        this.put(START_LINE, startLine);
        this.put(START_LINE_TYPE, startLineType);
    }

    @Schema(description="The line number where the multiline comment will begin", implementation=Integer.class, example="5")
    @Positive(message="{bitbucket.rest.comment.anchor.multiline.negativemarker}")
    public @Positive(message="{bitbucket.rest.comment.anchor.multiline.negativemarker}") int getStartLine() {
        Object value = this.get(START_LINE);
        if (value instanceof Number) {
            return (Integer)value;
        }
        return -1;
    }

    @Schema(description="The segment type of the start line of the multiline comment")
    @NotNull(message="{bitbucket.rest.comment.anchor.multiline.invalidstartlinetype}")
    public @NotNull(message="{bitbucket.rest.comment.anchor.multiline.invalidstartlinetype}") DiffSegmentType getStartLineType() {
        return this.getEnumProperty(START_LINE_TYPE, DiffSegmentType.class, null);
    }
}

