/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.comment;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.content.RestCommentThreadDiffAnchor;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiff;
import com.atlassian.bitbucket.rest.v2.api.property.RestPropertySupport;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonSerialize
@JsonSurrogate(value=Comment.class)
public class RestComment
extends RestPropertySupport {
    public static final Function<Comment, RestComment> REST_TRANSFORM = new Function<Comment, RestComment>(){

        @Override
        public RestComment apply(Comment comment) {
            return new RestComment(comment, this);
        }
    };
    private static final String ANCHOR = "anchor";
    private static final String AUTHOR = "author";
    private static final String COMMENTS = "comments";
    private static final String CREATED_DATE = "createdDate";
    private static final String HTML = "html";
    private static final String ID = "id";
    private static final String PARENT = "parent";
    private static final String RESOLVED_DATE = "resolvedDate";
    private static final String RESOLVER = "resolver";
    private static final String SEVERITY = "severity";
    private static final String STATE = "state";
    private static final String TEXT = "text";
    private static final String THREAD_RESOLVED = "threadResolved";
    private static final String THREAD_RESOLVED_DATE = "threadResolvedDate";
    private static final String THREAD_RESOLVER = "threadResolver";
    private static final String UPDATED_DATE = "updatedDate";
    private static final String VERSION = "version";

    public RestComment() {
    }

    public RestComment(Map<String, Object> values) {
        this.putAll(values);
    }

    public RestComment(@Nonnull Comment comment) {
        this(comment, REST_TRANSFORM);
    }

    public RestComment(CommentThread thread) {
        this(thread.getRootComment(), thread.getAnchor().map(RestCommentThreadDiffAnchor::new).orElse(null), REST_TRANSFORM, null, thread.isResolved());
        this.putIfNotNull("pullRequest", thread.getCommentable().accept((CommentableVisitor)new CommentableVisitor<RestPullRequest>(){

            public RestPullRequest visit(@Nonnull CommitDiscussion discussion) {
                return null;
            }

            public RestPullRequest visit(@Nonnull PullRequest pullRequest) {
                return new RestPullRequest(pullRequest);
            }
        }));
    }

    public RestComment(@Nonnull Comment comment, @Nullable Function<Comment, RestComment> replyTransformer) {
        this(comment, comment.getAnchor().map(RestCommentThreadDiffAnchor::new).orElse(null), replyTransformer);
    }

    public RestComment(@Nonnull Comment comment, @Nullable RestCommentThreadDiffAnchor anchor, @Nullable Function<Comment, RestComment> replyTransformer) {
        this(comment, anchor, replyTransformer, null, comment.getThread().isResolved());
    }

    public RestComment(@Nonnull Comment comment, @Nullable RestCommentThreadDiffAnchor anchor, @Nullable Function<Comment, RestComment> replyTransformer, @Nullable Diff diff) {
        this(comment, anchor, replyTransformer, diff, comment.getThread().isResolved());
    }

    public RestComment(@Nonnull Comment comment, @Nullable RestCommentThreadDiffAnchor anchor, @Nullable Function<Comment, RestComment> replyTransformer, @Nullable Diff diff, boolean threadResolved) {
        this(comment.getId(), comment.getVersion(), comment.getText(), anchor, new RestApplicationUser(comment.getAuthor()), comment.getCreatedDate(), comment.getUpdatedDate(), null, replyTransformer == null ? null : RestComment.transform(comment.getComments(), replyTransformer), comment.getProperties(), comment.getSeverity(), comment.getState(), threadResolved);
        CommentThread commentThread;
        comment.getPermittedOperations().ifPresent(operations -> {
            HashMap permittedOperations = Maps.newHashMap();
            permittedOperations.put("editable", operations.isEditable());
            permittedOperations.put("deletable", operations.isDeletable());
            permittedOperations.put("transitionable", operations.isTransitionable());
            this.put("permittedOperations", permittedOperations);
        });
        this.putIfNotNull(RESOLVED_DATE, comment.getResolvedDate());
        if (comment.getResolver() != null) {
            this.putIfNotEmpty(RESOLVER, new RestApplicationUser(comment.getResolver()));
        }
        if (comment.equals((commentThread = comment.getThread()).getRootComment())) {
            this.putIfNotNull(THREAD_RESOLVED_DATE, commentThread.getResolvedDate());
            if (commentThread.getResolver() != null) {
                this.putIfNotEmpty(THREAD_RESOLVER, new RestApplicationUser(commentThread.getResolver()));
            }
        }
        if (diff != null) {
            this.putIfNotNull("diff", RestDiff.REST_TRANSFORM.apply(diff));
        }
    }

    private RestComment(long id, Integer version, String text, RestCommentThreadDiffAnchor anchor, RestApplicationUser author, Date created, Date updated, RestComment parent, List<RestComment> replies, PropertyMap properties, CommentSeverity severity, CommentState state, boolean threadResolved) {
        super((Map<String, Object>)properties);
        if (id > 0L) {
            this.put(ID, id);
        }
        this.putIfNotNull(VERSION, version);
        this.putIfNotNull(TEXT, text);
        this.putIfNotNull(AUTHOR, author);
        this.putIfNotNull(CREATED_DATE, created);
        this.putIfNotNull(UPDATED_DATE, updated);
        this.putIfNotNull(COMMENTS, replies);
        this.putIfNotNull(PARENT, parent);
        this.putIfNotNull(ANCHOR, anchor);
        this.put(THREAD_RESOLVED, threadResolved);
        if (severity != null) {
            this.put(SEVERITY, severity.name());
        }
        if (state != null) {
            this.put(STATE, state.name());
        }
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestCommentThreadDiffAnchor getAnchor() {
        Object anchor = this.get(ANCHOR);
        if (anchor instanceof RestCommentThreadDiffAnchor) {
            return (RestCommentThreadDiffAnchor)anchor;
        }
        if (anchor instanceof Map) {
            return new RestCommentThreadDiffAnchor((Map)anchor);
        }
        return null;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestApplicationUser getAuthor() {
        return (RestApplicationUser)this.get(AUTHOR);
    }

    @ArraySchema(schema=@Schema(implementation=RestComment.class, accessMode=Schema.AccessMode.READ_ONLY))
    public List<RestComment> getComments() {
        return (List)this.get(COMMENTS);
    }

    @Schema(example="1359075920", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedDate() {
        return this.getLongProperty(CREATED_DATE);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public String getHtml() {
        return this.getStringProperty(HTML);
    }

    @Schema(example="1")
    public long getId() {
        return this.getLongProperty(ID);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestComment getParent() {
        Object parent = this.get(PARENT);
        if (parent instanceof RestComment) {
            return (RestComment)parent;
        }
        if (parent instanceof Map) {
            return new RestComment((Map)parent);
        }
        return null;
    }

    @Schema(example="1239075920", accessMode=Schema.AccessMode.READ_ONLY)
    public long getResolvedDate() {
        return this.getLongProperty(RESOLVED_DATE);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestApplicationUser getResolver() {
        return (RestApplicationUser)this.get(RESOLVER);
    }

    @Schema(example="NORMAL")
    public String getSeverity() {
        return this.getStringProperty(SEVERITY);
    }

    @Schema(example="OPEN")
    public String getState() {
        return this.getStringProperty(STATE);
    }

    @Schema(example="An insightful comment.")
    public String getText() {
        return this.getStringProperty(TEXT);
    }

    @Schema(example="1569075920", accessMode=Schema.AccessMode.READ_ONLY)
    public long getThreadResolvedDate() {
        return this.getLongProperty(THREAD_RESOLVED_DATE);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestApplicationUser getThreadResolver() {
        return (RestApplicationUser)this.get(THREAD_RESOLVER);
    }

    @Schema(example="1449075920", accessMode=Schema.AccessMode.READ_ONLY)
    public long getUpdatedDate() {
        return this.getLongProperty(UPDATED_DATE);
    }

    @Schema(example="1")
    public int getVersion() {
        return this.getIntProperty(VERSION);
    }

    public boolean hasThreadResolved() {
        return this.containsKey(THREAD_RESOLVED);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isAnchored() {
        return this.containsKey(ANCHOR);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isPending() {
        return CommentState.PENDING.name().equalsIgnoreCase(this.getStringProperty(STATE));
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isReply() {
        return this.containsKey(PARENT);
    }

    @Schema(description="Indicates if this comment thread has been marked as resolved or not")
    public boolean isThreadResolved() {
        return this.getBoolProperty(THREAD_RESOLVED);
    }

    public void setHtml(String html) {
        this.put(HTML, html);
    }
}

