/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.resolver;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import javax.annotation.Nonnull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.PathParam;

public class RepositoryResolver {
    private final I18nService i18nService;
    private final ProjectResolver projectResolver;
    private final String repositorySlug;
    private Repository repository;

    public RepositoryResolver(I18nService i18nService, RepositoryService repositoryService, @BeanParam ProjectResolver projectResolver, @PathParam(value="repositorySlug") String repositorySlug) {
        this.i18nService = i18nService;
        this.projectResolver = projectResolver;
        this.repositorySlug = repositorySlug;
        this.repository = repositoryService.getBySlug(projectResolver.parseProjectKey(projectResolver.getProjectKey()), this.parseRepositorySlug(repositorySlug));
    }

    @Nonnull
    public Repository getRepository() {
        if (this.repository == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo", new Object[]{this.projectResolver.getProjectKey(), this.repositorySlug}), this.projectResolver.getProject());
        }
        return this.repository;
    }

    private String parseRepositorySlug(String repoSlug) {
        if (repoSlug == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo", new Object[]{this.projectResolver.getProjectKey(), this.repositorySlug}), this.projectResolver.getProject());
        }
        return repoSlug;
    }
}

