/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.pull;

import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.rest.v2.api.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequestParticipant;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequestRef;
import com.atlassian.bitbucket.rest.v2.api.util.RestNamedLink;
import com.atlassian.bitbucket.rest.v2.api.util.RestRelatedLinks;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
@JsonSurrogate(value=PullRequest.class)
public class RestPullRequest
extends RestLinkedMapEntity {
    public static final Function<PullRequest, RestPullRequest> REST_TRANSFORM = RestPullRequest::new;
    private static final String AUTHOR = "author";
    private static final String CLOSED = "closed";
    private static final String CLOSED_DATE = "closedDate";
    private static final String CREATED_DATE = "createdDate";
    private static final String DESCRIPTION = "description";
    private static final String DESCRIPTION_AS_HTML = "descriptionAsHtml";
    private static final String DRAFT = "draft";
    private static final String FROM_REF = "fromRef";
    private static final String ID = "id";
    private static final String LOCKED = "locked";
    private static final String OPEN = "open";
    private static final String PARTICIPANTS = "participants";
    private static final String REVIEWERS = "reviewers";
    private static final String STATE = "state";
    private static final String TITLE = "title";
    private static final String TO_REF = "toRef";
    private static final String UPDATED_DATE = "updatedDate";
    private static final String VERSION = "version";

    public RestPullRequest() {
    }

    public RestPullRequest(PullRequest pullRequest) {
        this(pullRequest.getId(), pullRequest.getVersion(), pullRequest.getTitle(), pullRequest.getDescription(), pullRequest.getState(), pullRequest.getCreatedDate(), pullRequest.getUpdatedDate(), pullRequest.getClosedDate(), new RestPullRequestRef(pullRequest.getFromRef()), new RestPullRequestRef(pullRequest.getToRef()), pullRequest.isLocked(), new RestPullRequestParticipant(pullRequest.getAuthor()), RestPullRequest.getRestParticipants(pullRequest.getReviewers()), RestPullRequest.getRestParticipants(pullRequest.getParticipants()), pullRequest.getProperties(), null, pullRequest.isDraft());
    }

    private RestPullRequest(Map<String, Object> values) {
        super(values);
    }

    private RestPullRequest(long id, int version, String title, String description, PullRequestState state, Date created, Date updated, Date closed, RestPullRequestRef from, RestPullRequestRef to, Boolean locked, RestPullRequestParticipant author, Set<RestPullRequestParticipant> reviewers, Set<RestPullRequestParticipant> participants, PropertyMap properties, RestNamedLink selfLink, boolean draft) {
        if (id > 0L) {
            this.put(ID, id);
        }
        if (version != -1) {
            this.put(VERSION, version);
        }
        this.putIfNotNull(TITLE, title);
        this.putIfNotNull(DESCRIPTION, description);
        if (state != null) {
            this.put(STATE, state);
            this.put(OPEN, state == PullRequestState.OPEN);
            this.put(CLOSED, state != PullRequestState.OPEN);
        }
        this.put(DRAFT, draft);
        this.putIfNotNull(CREATED_DATE, created);
        this.putIfNotNull(UPDATED_DATE, updated);
        this.putIfNotNull(CLOSED_DATE, closed);
        this.putIfNotNull(FROM_REF, from);
        this.putIfNotNull(TO_REF, to);
        this.putIfNotNull(LOCKED, locked);
        this.putIfNotNull(AUTHOR, author);
        this.putIfNotNull(REVIEWERS, reviewers);
        this.putIfNotNull(PARTICIPANTS, participants);
        this.putIfNotEmpty("properties", (Map<?, ?>)properties);
        if (selfLink != null) {
            this.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", selfLink).build());
        }
    }

    @Nullable
    public static RestPullRequest valueOf(@Nullable Object value) {
        if (value instanceof RestPullRequest) {
            return (RestPullRequest)value;
        }
        if (value instanceof Map) {
            return new RestPullRequest((Map)value);
        }
        return null;
    }

    @Schema(example="19990759200")
    public long getClosedDate() {
        return this.getLongProperty(CLOSED_DATE);
    }

    @Schema(example="13590759200")
    public long getCreatedDate() {
        return this.getLongProperty(CREATED_DATE);
    }

    @Schema(example="It is a kludge, but put the tuple from the database in the cache.")
    public String getDescription() {
        return StringUtils.trimToNull((String)this.getStringProperty(DESCRIPTION));
    }

    @VisibleForTesting
    public String getDescriptionAsHtml() {
        return StringUtils.trimToNull((String)this.getStringProperty(DESCRIPTION_AS_HTML));
    }

    public RestPullRequestRef getFromRef() {
        return RestPullRequestRef.valueOf(this.get(FROM_REF));
    }

    @Schema(example="1")
    public long getId() {
        return this.getLongProperty(ID);
    }

    @ArraySchema(schema=@Schema(implementation=RestPullRequestParticipant.class))
    public Set<RestPullRequestParticipant> getParticipants() {
        return this.getParticipants(PARTICIPANTS);
    }

    @ArraySchema(schema=@Schema(implementation=RestPullRequestParticipant.class))
    public Set<RestPullRequestParticipant> getReviewers() {
        return this.getParticipants(REVIEWERS);
    }

    public PullRequestState getState() {
        return this.getEnumProperty(STATE, PullRequestState.class);
    }

    @Schema(example="Talking Nerdy")
    public String getTitle() {
        return StringUtils.trimToNull((String)this.getStringProperty(TITLE));
    }

    public RestPullRequestRef getToRef() {
        return RestPullRequestRef.valueOf(this.get(TO_REF));
    }

    @Schema(example="14490759200")
    public long getUpdatedDate() {
        return this.getLongProperty(UPDATED_DATE);
    }

    public int getVersion() {
        return this.getIntProperty(VERSION);
    }

    public boolean hasAuthor() {
        return this.containsKey(AUTHOR);
    }

    public boolean hasDescription() {
        return this.getStringProperty(DESCRIPTION) != null;
    }

    public boolean hasDraft() {
        return this.containsKey(DRAFT);
    }

    public boolean hasParticipants() {
        return this.containsKey(PARTICIPANTS);
    }

    public boolean hasReviewers() {
        return this.containsKey(REVIEWERS);
    }

    public boolean hasTitle() {
        return this.getTitle() != null;
    }

    public boolean hasVersion() {
        return this.containsKey(VERSION);
    }

    public boolean isClosed() {
        return this.getBoolProperty(CLOSED);
    }

    public boolean isDraft() {
        return this.getBoolProperty(DRAFT);
    }

    public boolean isLocked() {
        return this.getBoolProperty(LOCKED);
    }

    public boolean isOpen() {
        return this.getBoolProperty(OPEN);
    }

    public void setHtmlDescription(String html) {
        this.put(DESCRIPTION_AS_HTML, html);
    }

    private static Set<RestPullRequestParticipant> getRestParticipants(Set<PullRequestParticipant> participants) {
        return RestPullRequest.transform(participants, RestPullRequestParticipant.REST_TRANSFORM);
    }

    private Set<RestPullRequestParticipant> getParticipants(String key) {
        Collection<Object> rawReviewers;
        Object value = this.get(key);
        Collection<Object> collection = rawReviewers = value instanceof Collection ? (Collection)value : Collections.emptySet();
        if (!rawReviewers.isEmpty()) {
            HashSet<RestPullRequestParticipant> reviewers = new HashSet<RestPullRequestParticipant>(rawReviewers.size());
            for (Object rawReviewer : rawReviewers) {
                RestPullRequestParticipant reviewer = RestPullRequestParticipant.valueOf(rawReviewer);
                if (reviewer == null) continue;
                reviewers.add(reviewer);
            }
            return reviewers;
        }
        return Collections.emptySet();
    }
}

