/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.pull;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.comment.CommentSearchRequest;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.dmz.comment.DmzCommentService;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.rest.v2.comment.RestCommentCount;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivitySearchRequest;
import com.atlassian.bitbucket.pull.PullRequestActivityType;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.content.RestCommentThreadDiffAnchor;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class InternalPullRequestCommentResource {
    private final AuthenticationContext authenticationContext;
    private final DmzCommentService commentService;
    private final I18nService i18nService;
    private final DmzPullRequestService pullRequestService;

    @Inject
    public InternalPullRequestCommentResource(AuthenticationContext authenticationContext, DmzCommentService commentService, I18nService i18nService, DmzPullRequestService pullRequestService) {
        this.i18nService = i18nService;
        this.authenticationContext = authenticationContext;
        this.commentService = commentService;
        this.pullRequestService = pullRequestService;
    }

    @GET
    @Path(value="count")
    public Response countComments(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="path") String path, @QueryParam(value="severity") List<String> severities, @QueryParam(value="state") List<String> states) {
        Map commentCounts = this.commentService.countCommentsByState(new CommentSearchRequest.Builder((Commentable)pullRequestResolver.getPullRequest()).anchorState(CommentThreadDiffAnchorState.ALL).path(path).pendingAuthor(this.authenticationContext.getCurrentUser()).severities(this.toSeverities(severities)).states(this.toCommentStates(states, CommentState.values())).build());
        return ResponseFactory.ok().entity(RestCommentCount.REST_TRANSFORM.apply(commentCounts)).build();
    }

    @GET
    @Path(value="count-other")
    public Response countOtherComments(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="anchorState") String anchorState, @QueryParam(value="diffType") List<String> diffTypes, @QueryParam(value="fromHash") String fromHash, @QueryParam(value="path") String path, @QueryParam(value="toHash") String toHash) {
        PullRequest pullRequest = pullRequestResolver.getPullRequest();
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comments.findrequirespath", new Object[0]));
        }
        long count = this.commentService.countOtherComments(new CommentSearchRequest.Builder((Commentable)pullRequest).anchorState(this.toAnchorState(anchorState)).diffTypes(this.toDiffTypes(diffTypes)).fromHash(fromHash).path(path).toHash(toHash).build());
        return ResponseFactory.ok().entity(Collections.singletonMap("comments", count)).build();
    }

    @GET
    public Response getComments(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="severity") List<String> severities, @QueryParam(value="state") List<String> states, @BeanParam PageRequestResolver pageRequestResolver) {
        CommentSearchRequest requestBuilder = new CommentSearchRequest.Builder((Commentable)pullRequestResolver.getPullRequest()).anchorState(CommentThreadDiffAnchorState.ALL).severities(this.toSeverities(severities)).states(this.toCommentStates(states, CommentState.values())).pendingAuthor(this.authenticationContext.getCurrentUser()).build();
        Page comments = this.commentService.search(requestBuilder, pageRequestResolver.getPageRequest());
        Set<Long> commentIds = comments.stream().filter(comment -> comment.getProperties().containsKey((Object)"suggestionState")).map(Comment::getId).collect(Collectors.toSet());
        Map<Long, Diff> commentDiffs = this.getCommentDiffs(pullRequestResolver.getPullRequest(), commentIds);
        Page page = PageUtils.createPage((Iterable)((Iterable)comments.stream().map(comment -> new RestComment(comment, comment.getAnchor().isPresent() ? new RestCommentThreadDiffAnchor((CommentThreadDiffAnchor)comment.getAnchor().get()) : null, null, (Diff)commentDiffs.get(comment.getId()), comment.getThread().isResolved())).collect(MoreCollectors.toImmutableList())), (boolean)comments.getIsLastPage(), (PageRequest)pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page)).build();
    }

    @GET
    @Path(value="other-threads")
    public Response getOtherThreads(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="anchorState") String anchorState, @QueryParam(value="diffType") List<String> diffTypes, @QueryParam(value="fromHash") String fromHash, @QueryParam(value="path") String path, @QueryParam(value="toHash") String toHash, @BeanParam PageRequestResolver pageRequestResolver) {
        PullRequest pullRequest = pullRequestResolver.getPullRequest();
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comments.findrequirespath", new Object[0]));
        }
        Page threads = this.commentService.searchOtherThreads(new CommentSearchRequest.Builder((Commentable)pullRequest).anchorState(this.toAnchorState(anchorState)).diffTypes(this.toDiffTypes(diffTypes)).fromHash(fromHash).path(path).toHash(toHash).build(), pageRequestResolver.getPageRequest());
        Set<Long> rootCommentIds = threads.stream().filter(t -> t.getAnchor().isPresent() && ((CommentThreadDiffAnchor)t.getAnchor().get()).isLineAnchor()).map(CommentThread::getRootComment).map(Comment::getId).collect(Collectors.toSet());
        Map<Long, Diff> commentDiffs = this.getCommentDiffs(pullRequest, rootCommentIds);
        Page page = PageUtils.createPage((Iterable)((Iterable)threads.stream().map(CommentThread::getRootComment).map(comment -> new RestComment(comment, comment.getAnchor().isPresent() ? new RestCommentThreadDiffAnchor((CommentThreadDiffAnchor)comment.getAnchor().get()) : null, RestComment.REST_TRANSFORM, (Diff)commentDiffs.get(comment.getId()), comment.getThread().isResolved())).collect(MoreCollectors.toImmutableList())), (boolean)threads.getIsLastPage(), (PageRequest)pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page)).build();
    }

    private Map<Long, Diff> getCommentDiffs(PullRequest pullRequest, Set<Long> commentIds) {
        if (commentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Page commentActivities = this.pullRequestService.searchActivities(new PullRequestActivitySearchRequest.Builder(pullRequest).commentIds(commentIds).commentActions(CommentAction.ADDED, new CommentAction[]{CommentAction.REPLIED}).types(PullRequestActivityType.COMMENT, new PullRequestActivityType[0]).build(), PageUtils.newRequest((int)0, (int)commentIds.size()));
        ImmutableMap.Builder diffsBuilder = ImmutableMap.builder();
        commentActivities.forEach(activity -> {
            PullRequestCommentActivity commentActivity = (PullRequestCommentActivity)activity;
            commentActivity.getDiff().ifPresent(diff -> diffsBuilder.put((Object)commentActivity.getComment().getId(), diff));
        });
        return diffsBuilder.build();
    }

    @Nonnull
    private CommentThreadDiffAnchorState toAnchorState(@Nonnull String anchorState) {
        try {
            return StringUtils.isEmpty((CharSequence)anchorState) ? CommentThreadDiffAnchorState.ACTIVE : CommentThreadDiffAnchorState.valueOf((String)anchorState.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comment.anchor.invalidstate", new Object[]{anchorState, this.toUppercaseNames((Enum[])CommentThreadDiffAnchorState.values())}));
        }
    }

    @Nullable
    protected CommentState toCommentState(@Nonnull String commentState, CommentState ... validStates) {
        try {
            return StringUtils.isEmpty((CharSequence)commentState) ? null : CommentState.valueOf((String)commentState.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.ui.comment.invalidstate", new Object[]{commentState, this.toUppercaseNames((Enum[])validStates)}));
        }
    }

    @Nonnull
    private List<CommentState> toCommentStates(List<String> commentStates, CommentState ... validStates) {
        return CollectionUtils.isEmpty(commentStates) ? ImmutableList.of() : commentStates.stream().map(validState -> this.toCommentState((String)validState, validStates)).collect(Collectors.toList());
    }

    @Nonnull
    private CommentThreadDiffAnchorType toDiffType(@Nonnull String diffType) {
        try {
            return StringUtils.isEmpty((CharSequence)diffType) ? CommentThreadDiffAnchorType.EFFECTIVE : CommentThreadDiffAnchorType.valueOf((String)diffType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.difftype.invalid", new Object[]{this.toUppercaseNames((Enum[])CommentThreadDiffAnchorType.values())}));
        }
    }

    @Nullable
    private List<CommentThreadDiffAnchorType> toDiffTypes(List<String> diffTypes) {
        return CollectionUtils.isEmpty(diffTypes) ? null : diffTypes.stream().map(this::toDiffType).collect(Collectors.toList());
    }

    @Nullable
    private CommentSeverity toSeverity(@Nonnull String severity) {
        try {
            return StringUtils.isEmpty((CharSequence)severity) ? null : CommentSeverity.valueOf((String)severity.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.ui.comment.invalidseverity", new Object[]{severity, this.toUppercaseNames((Enum[])CommentSeverity.values())}));
        }
    }

    @Nonnull
    private List<CommentSeverity> toSeverities(List<String> severities) {
        return CollectionUtils.isEmpty(severities) ? ImmutableList.of() : severities.stream().map(this::toSeverity).collect(Collectors.toList());
    }

    @Nonnull
    private List<String> toUppercaseNames(@Nonnull Enum[] values) {
        return (List)Arrays.stream(values).map(value -> value.name().toUpperCase(Locale.ROOT)).collect(MoreCollectors.toImmutableList());
    }
}

