/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.deployment;

import com.atlassian.bitbucket.dmz.deployments.CommitDeploymentSearchRequest;
import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.deployment.AbstractInternalDeploymentResource;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@UnrestrictedAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/deployments")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class InternalCommitDeploymentResource
extends AbstractInternalDeploymentResource {
    @Inject
    public InternalCommitDeploymentResource(DeploymentService deploymentService, I18nService i18nService) {
        super(deploymentService, i18nService);
    }

    @GET
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response search(@PathParam(value="commitId") String commitId, @BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="state") String state, @BeanParam PageRequestResolver pageRequestResolver) {
        CommitDeploymentSearchRequest searchRequest = ((CommitDeploymentSearchRequest.Builder)new CommitDeploymentSearchRequest.Builder(repositoryResolver.getRepository(), commitId).state(this.getState(state))).build();
        Page result = this.deploymentService.search(searchRequest, pageRequestResolver.getPageRequest());
        return this.toResponse((Page<Deployment>)result);
    }
}

