/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.deployment;

import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentService;
import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.bitbucket.dmz.rest.v2.deployment.RestDeployment;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class AbstractInternalDeploymentResource {
    protected static final String STATE = "state";
    protected final DeploymentService deploymentService;
    private final I18nService i18nService;

    @Inject
    public AbstractInternalDeploymentResource(DeploymentService deploymentService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.deploymentService = deploymentService;
    }

    @Nullable
    protected DeploymentState getState(String state) {
        if (StringUtils.isBlank((CharSequence)state)) {
            return null;
        }
        return (DeploymentState)DeploymentState.fromString((String)state).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.deployment.state.invalid", new Object[0])));
    }

    @Nonnull
    protected Response toResponse(Page<Deployment> result) {
        return Response.ok((Object)new RestPage(result, RestDeployment::new)).build();
    }
}

