/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.operations;

import com.atlassian.bitbucket.build.server.operations.ActionResult;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RestActionResult
extends RestMapEntity {
    private static final String MESSAGE = "message";
    private static final String STATE = "state";
    private static final String URL = "url";

    public RestActionResult() {
    }

    public RestActionResult(@Nonnull ActionResult actionResult) {
        this(Objects.requireNonNull(actionResult, "actionResult").getMessage().orElse(null), actionResult.getState().name(), actionResult.getURI().map(URI::toString).orElse(null));
    }

    public RestActionResult(@Nullable String message, @Nonnull String state, @Nullable String url) {
        this.putIfNotNull(MESSAGE, StringUtils.stripToNull((String)message));
        this.put(STATE, Objects.requireNonNull(state));
        this.putIfNotNull(URL, StringUtils.stripToNull((String)url));
    }

    private RestActionResult(Map<String, Object> values) {
        super(values);
    }

    public String getMessage() {
        return this.getStringProperty(MESSAGE);
    }

    public String getState() {
        return this.getStringProperty(STATE);
    }

    public String getUrl() {
        return this.getStringProperty(URL);
    }

    public static RestActionResult valueOf(Object value) {
        if (value instanceof RestActionResult) {
            return (RestActionResult)((Object)value);
        }
        if (value instanceof ActionResult) {
            return new RestActionResult((ActionResult)value);
        }
        if (value instanceof Map) {
            return new RestActionResult((Map)value);
        }
        return null;
    }
}

