/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.bitbucket.dmz.server.AttachDataStoreRequest;
import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.dmz.server.DmzDataStoreService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.admin.RestAttachRequest;
import com.atlassian.bitbucket.internal.rest.admin.RestDataStore;
import com.atlassian.bitbucket.internal.rest.admin.RestDataStoreConfig;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/storage")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class StorageResource {
    private final DmzDataStoreService dataStoreService;
    private final I18nService i18nService;
    private final Validator validator;

    @Inject
    public StorageResource(DmzDataStoreService dataStoreService, I18nService i18nService, Validator validator) {
        this.i18nService = i18nService;
        this.dataStoreService = dataStoreService;
        this.validator = validator;
    }

    @POST
    @Path(value="/attach")
    public Response attach(RestAttachRequest request, @QueryParam(value="dryRun") @DefaultValue(value="false") boolean dryRun) {
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        AttachDataStoreRequest attachRequest = new AttachDataStoreRequest.Builder(request.getPath()).dryRun(dryRun).build();
        DataStore newDataStore = this.dataStoreService.attach(attachRequest);
        return ResponseFactory.ok((Object)((Object)new RestDataStore(newDataStore))).build();
    }

    @GET
    public Response getDataStoreConfig() {
        return ResponseFactory.ok((Object)((Object)new RestDataStoreConfig(this.dataStoreService.getConfig()))).build();
    }
}

