/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshRemigrator;
import com.atlassian.bitbucket.dmz.migration.DmzMigrationService;
import com.atlassian.bitbucket.dmz.rest.v2.job.RestJob;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/git/mesh/remigration")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class MeshRemigrationResource {
    private final DmzMigrationService migrationService;
    private final DmzMeshRemigrator remigrator;

    @Inject
    public MeshRemigrationResource(DmzMigrationService migrationService, DmzMeshRemigrator remigrator) {
        this.migrationService = migrationService;
        this.remigrator = remigrator;
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/abort")
    public Response abort(@BeanParam RepositoryResolver repositoryResolver) {
        this.remigrator.abort(repositoryResolver.getRepository());
        return ResponseFactory.noContent().build();
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/commit")
    public Response commit(@BeanParam RepositoryResolver repositoryResolver) {
        this.remigrator.commit(repositoryResolver.getRepository());
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="{jobId}")
    public Response getMeshRemigrationJob(@PathParam(value="jobId") long jobId) {
        return this.migrationService.getMeshRemigrationJob(jobId).map(RestJob::new).map(ResponseFactory::ok).orElseGet(ResponseFactory::notFound).build();
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/prepare")
    public Response prepare(@BeanParam RepositoryResolver repositoryResolver) {
        List repositories = this.remigrator.prepare(repositoryResolver.getRepository());
        return ResponseFactory.ok((Object)ImmutableMap.of((Object)"hierarchyId", (Object)repositoryResolver.getRepository().getHierarchyId(), (Object)"ids", repositories.stream().map(Repository::getId).collect(Collectors.toList()))).build();
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}")
    public Response remigrate(@BeanParam RepositoryResolver repositoryResolver) {
        Job job = this.migrationService.startMeshRemigration(repositoryResolver.getRepository());
        return ResponseFactory.ok((Object)new RestJob(job)).build();
    }

    @PUT
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/partition/{partitionId}")
    public Response setPartitionId(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="partitionId") int partitionId) {
        this.remigrator.setPartition(repositoryResolver.getRepository(), partitionId);
        return ResponseFactory.ok().build();
    }
}

