/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.pull.template;

import com.atlassian.bitbucket.dmz.pull.template.PullRequestTemplate;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.scope.RestScope;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonSerialize
@JsonSurrogate(value=PullRequestTemplate.class)
public class RestPullRequestTemplate
extends RestMapEntity {
    private static final String DESCRIPTION = "description";
    private static final String ENABLED = "enabled";
    private static final String SCOPE = "scope";

    public RestPullRequestTemplate() {
    }

    public RestPullRequestTemplate(PullRequestTemplate template) {
        this(template.getDescription(), template.isEnabled(), new RestScope(template.getScope()));
    }

    public RestPullRequestTemplate(String description, boolean enabled) {
        this.put(DESCRIPTION, description);
        this.put(ENABLED, enabled);
    }

    public RestPullRequestTemplate(String description, boolean enabled, RestScope scope) {
        this.put(DESCRIPTION, description);
        this.put(ENABLED, enabled);
        this.put(SCOPE, scope);
    }

    @NotNull(message="{bitbucket.rest.pull.request.template.description.required}")
    @Size(max=32768, message="{bitbucket.rest.pull.request.template.description.max.length}")
    public @NotNull(message="{bitbucket.rest.pull.request.template.description.required}") @Size(max=32768, message="{bitbucket.rest.pull.request.template.description.max.length}") String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    @AssertTrue(message="{bitbucket.rest.pull.request.template.enabled.required}")
    public @AssertTrue(message="{bitbucket.rest.pull.request.template.enabled.required}") boolean hasEnabled() {
        return this.containsKey(ENABLED);
    }

    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED);
    }
}

