/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.pull.template;

import com.atlassian.bitbucket.dmz.pull.template.DmzPullRequestTemplateService;
import com.atlassian.bitbucket.dmz.pull.template.PullRequestTemplate;
import com.atlassian.bitbucket.internal.rest.pull.template.RestPullRequestTemplate;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.ValidationUtils;
import javax.validation.Validator;
import javax.ws.rs.core.Response;

public class PullRequestTemplateResourceHelper {
    public static final String ENDPOINT = "/pull-request-templates";
    private final FeatureManager featureManager;
    private final DmzPullRequestTemplateService pullRequestTemplateService;
    private final Validator validator;

    public PullRequestTemplateResourceHelper(FeatureManager featureManager, DmzPullRequestTemplateService pullRequestTemplateService, Validator validator) {
        this.featureManager = featureManager;
        this.pullRequestTemplateService = pullRequestTemplateService;
        this.validator = validator;
    }

    public Response create(Scope scope, RestPullRequestTemplate request) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_TEMPLATES)) {
            return ResponseFactory.notFound().build();
        }
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        if (scope.getType() == ScopeType.GLOBAL) {
            return ResponseFactory.notFound().build();
        }
        PullRequestTemplate template = this.pullRequestTemplateService.setTemplate(scope, request.getDescription(), request.isEnabled());
        return ResponseFactory.ok((Object)((Object)new RestPullRequestTemplate(template))).build();
    }

    public Response delete(Scope scope) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_TEMPLATES)) {
            return ResponseFactory.notFound().build();
        }
        if (scope.getType() == ScopeType.GLOBAL) {
            return ResponseFactory.notFound().build();
        }
        this.pullRequestTemplateService.deleteTemplate(scope);
        return ResponseFactory.noContent().build();
    }

    public Response getTemplate(Scope scope) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_TEMPLATES)) {
            return ResponseFactory.noContent().build();
        }
        if (scope.getType() == ScopeType.GLOBAL) {
            return ResponseFactory.notFound().build();
        }
        return this.pullRequestTemplateService.getTemplate(scope).map(template -> ResponseFactory.ok((Object)((Object)new RestPullRequestTemplate((PullRequestTemplate)template))).build()).orElseGet(() -> ResponseFactory.noContent().build());
    }
}

