/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.pull;

import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.internal.rest.pull.RestPullRequestAutoMergeability;
import com.atlassian.bitbucket.internal.rest.pull.RestPullRequestDraftRequest;
import com.atlassian.bitbucket.pull.AutoMergeCancelledReason;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.pull.automerge.AutoMergeService;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class InternalPullRequestResource {
    private final AutoMergeService autoMergeService;
    private final DmzPullRequestService pullRequestService;

    @Inject
    public InternalPullRequestResource(AutoMergeService autoMergeService, DmzPullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
        this.autoMergeService = autoMergeService;
    }

    @DELETE
    @Path(value="auto-merge")
    public Response cancelAutoMerge(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PullRequestResolver pullRequestResolver) {
        this.autoMergeService.cancelAutoMerge(repositoryResolver.getRepository().getId(), pullRequestResolver.getPullRequest().getId(), AutoMergeCancelledReason.USER_CANCELLED_REQUEST);
        return this.canMerge(repositoryResolver, pullRequestResolver);
    }

    @GET
    @Path(value="merge")
    public Response canMerge(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PullRequestResolver pullRequestResolver) {
        PullRequestMergeability mergeability = this.pullRequestService.canMerge(repositoryResolver.getRepository().getId(), pullRequestResolver.getPullRequest().getId());
        boolean settingEnabled = this.autoMergeService.isSettingEnabledForPullRequest(pullRequestResolver.getPullRequest());
        boolean autoMergeRequested = settingEnabled && this.autoMergeService.getAutoMergeRequest(pullRequestResolver.getPullRequest()).isPresent();
        boolean canRequestAutoMerge = settingEnabled && !autoMergeRequested && !mergeability.isConflicted() && !mergeability.canMerge();
        return ResponseFactory.ok((Object)((Object)new RestPullRequestAutoMergeability(mergeability, autoMergeRequested, canRequestAutoMerge))).build();
    }

    @PUT
    @Path(value="draft")
    public Response updateDraftStatus(@BeanParam PullRequestResolver pullRequestResolver, RestPullRequestDraftRequest request) {
        return ResponseFactory.ok().entity((Object)new RestPullRequest(this.pullRequestService.updateDraftStatus(pullRequestResolver.getPullRequest(), request.isDraft()))).build();
    }
}

