/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.providers;

import com.atlassian.bitbucket.dmz.pull.template.PullRequestTemplate;
import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.dmz.server.DataStoreConfig;
import com.atlassian.bitbucket.internal.rest.admin.RestDataStore;
import com.atlassian.bitbucket.internal.rest.admin.RestDataStoreConfig;
import com.atlassian.bitbucket.internal.rest.pull.template.RestPullRequestTemplate;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUiJsonRenderer
implements JsonRenderer {
    private static final Logger log = LoggerFactory.getLogger(RestUiJsonRenderer.class);
    private final JsonFactory jsonFactory = new ObjectMapper().getJsonFactory();

    /*
     * Enabled aggressive exception aggregation
     */
    public String render(@Nullable Object object, @Nonnull Map<String, Object> options) {
        RestMapEntity surrogate;
        if (object instanceof DataStore) {
            surrogate = new RestDataStore((DataStore)object);
        } else if (object instanceof DataStoreConfig) {
            surrogate = new RestDataStoreConfig((DataStoreConfig)object);
        } else if (object instanceof PullRequestTemplate) {
            surrogate = new RestPullRequestTemplate((PullRequestTemplate)object);
        } else {
            return null;
        }
        try (StringWriter writer = new StringWriter();){
            String string;
            block19: {
                JsonGenerator generator = this.jsonFactory.createJsonGenerator((Writer)writer);
                try {
                    generator.writeObject((Object)surrogate);
                    generator.flush();
                    string = writer.toString();
                    if (generator == null) break block19;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return string;
        }
        catch (IOException e) {
            log.error(String.format("Failed to render JSON for object of type %s with surrogate of type %s", object.getClass().getName(), surrogate.getClass().getName()), (Throwable)e);
            return null;
        }
    }
}

