/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.deployment;

import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentService;
import com.atlassian.bitbucket.dmz.deployments.PullRequestDeploymentSearchRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.deployment.AbstractInternalDeploymentResource;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/deployments")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class InternalPullRequestDeploymentResource
extends AbstractInternalDeploymentResource {
    @Inject
    public InternalPullRequestDeploymentResource(DeploymentService deploymentService, I18nService i18nService) {
        super(deploymentService, i18nService);
    }

    @GET
    public Response search(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="state") String state, @BeanParam PageRequestResolver pageRequestResolver) {
        PullRequestDeploymentSearchRequest searchRequest = ((PullRequestDeploymentSearchRequest.Builder)new PullRequestDeploymentSearchRequest.Builder(pullRequestResolver.getPullRequest()).state(this.getState(state))).build();
        Page result = this.deploymentService.search(searchRequest, pageRequestResolver.getPageRequest());
        return this.toResponse((Page<Deployment>)result);
    }
}

