/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.summary;

import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.dmz.build.status.PullRequestBulkCommitBuildStatusSummaryRequest;
import com.atlassian.bitbucket.internal.rest.build.summary.RestBuildSummaries;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/build-summaries")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class BuildStatusPullRequestSummaryResource {
    private final DmzBuildStatusService buildStatusService;

    @Inject
    public BuildStatusPullRequestSummaryResource(DmzBuildStatusService buildStatusService) {
        this.buildStatusService = buildStatusService;
    }

    @GET
    public Response search(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="commitId") List<String> commitIds) {
        PullRequestBulkCommitBuildStatusSummaryRequest request = ((PullRequestBulkCommitBuildStatusSummaryRequest.Builder)new PullRequestBulkCommitBuildStatusSummaryRequest.Builder(pullRequestResolver.getPullRequest(), new String[0]).commitIds(commitIds)).build();
        Map summaries = this.buildStatusService.getSummaries(request);
        return ResponseFactory.ok((Object)((Object)new RestBuildSummaries(summaries))).build();
    }
}

