/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.status;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.build.BuildOrder;
import com.atlassian.bitbucket.build.status.BuildStatusRepositorySearchRequest;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.dmz.build.status.BuildStatusParentSearchRequest;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.build.status.InternalRestBuildStatus;
import com.atlassian.bitbucket.internal.rest.build.status.RestBuildStatusParent;
import com.atlassian.bitbucket.internal.rest.build.status.RestBuildStatusSearchResponse;
import com.atlassian.bitbucket.internal.rest.build.status.RestBuildStatusTransformer;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRef;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/builds")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class BuildStatusRepositorySearchResource {
    private final DmzBuildStatusService buildStatusService;
    private final I18nService i18nService;
    private final RefService refService;
    private final RestBuildStatusTransformer restBuildStatusTransformer;

    @Inject
    public BuildStatusRepositorySearchResource(DmzBuildStatusService buildStatusService, I18nService i18nService, RefService refService, RestBuildStatusTransformer restBuildStatusTransformer) {
        this.i18nService = i18nService;
        this.buildStatusService = buildStatusService;
        this.refService = refService;
        this.restBuildStatusTransformer = restBuildStatusTransformer;
    }

    @GET
    public Response search(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="avatarSize") String avatarSize, @QueryParam(value="orderBy") @DefaultValue(value="newest") String orderBy, @QueryParam(value="at") String at, @BeanParam PageRequestResolver pageRequestResolver, @Context ContainerRequestContext requestContext) {
        BuildOrder buildOrder = (BuildOrder)BuildOrder.fromString((String)orderBy).orElseThrow(() -> new BadRequestException(this.i18nService.getMessage("bitbucket.rest.build.status.order.invalid", new Object[]{orderBy, Arrays.asList(BuildOrder.values())})));
        BuildStatusRepositorySearchRequest.Builder requestBuilder = (BuildStatusRepositorySearchRequest.Builder)new BuildStatusRepositorySearchRequest.Builder(repositoryResolver.getRepository()).buildOrder(buildOrder);
        RestRef restRef = null;
        if (StringUtils.isBlank((CharSequence)at)) {
            Branch defaultBranch = this.refService.getDefaultBranch(repositoryResolver.getRepository());
            restRef = new RestRef((Ref)defaultBranch);
            requestBuilder.ref((Ref)defaultBranch);
        } else if (ShaUtils.isHash((String)at)) {
            requestBuilder.commitId(at);
        } else {
            Ref resolvedRef = this.resolveRef(repositoryResolver.getRepository(), at);
            restRef = new RestRef(resolvedRef);
            requestBuilder.ref(resolvedRef);
        }
        Page page = this.buildStatusService.searchInternal(requestBuilder.build(), pageRequestResolver.getPageRequest());
        RestPage<InternalRestBuildStatus> restPage = this.restBuildStatusTransformer.transform((Page<RepositoryBuildStatus>)page, requestContext);
        return ResponseFactory.ok((Object)((Object)new RestBuildStatusSearchResponse(restRef, restPage))).build();
    }

    @GET
    @Path(value="/parents")
    public Response searchParents(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="filter") String filter, @QueryParam(value="earliestDate") Long earliestDate) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return ResponseFactory.badRequest((String)this.i18nService.getMessage("bitbucket.rest.search.build.parent.filter.required", new Object[0])).build();
        }
        BuildStatusParentSearchRequest searchRequest = new BuildStatusParentSearchRequest.Builder(repositoryResolver.getRepository(), filter).since(earliestDate).build();
        Page page = this.buildStatusService.getBuildParents(searchRequest, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestBuildStatusParent::new)).build();
    }

    protected Ref resolveRef(@Nonnull Repository repository, @Nonnull String ref) {
        Ref resolvedRef = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(ref).build());
        if (resolvedRef == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.build.status.no.such.ref", new Object[0]));
        }
        return resolvedRef;
    }
}

