/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.server;

import com.atlassian.bitbucket.dmz.build.server.DmzBuildServerAuthorizationService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.build.server.RestBuildServerAuthorizationStatus;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
@Path(value="/build-server")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class BuildServerResource {
    private final ApplicationPropertiesService applicationPropertiesService;
    private final DmzBuildServerAuthorizationService buildServerAuthorizationService;
    private final I18nService i18nService;

    @Inject
    public BuildServerResource(ApplicationPropertiesService applicationPropertiesService, DmzBuildServerAuthorizationService buildServerAuthorizationService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.applicationPropertiesService = applicationPropertiesService;
        this.buildServerAuthorizationService = buildServerAuthorizationService;
    }

    @GET
    @Path(value="/authorization-status")
    public Response authorize(@QueryParam(value="buildServerId") String buildServerId, @Context ContainerRequestContext containerRequest) {
        this.validateBuildServerId(buildServerId);
        return Response.ok((Object)((Object)new RestBuildServerAuthorizationStatus(this.buildServerAuthorizationService.getAuthorizationStatus(buildServerId)))).build();
    }

    @GET
    @Path(value="/authorize")
    public Response authorize(@QueryParam(value="buildServerId") String buildServerId, @QueryParam(value="callbackUrl") String callback, @Context ContainerRequestContext containerRequest) {
        this.validateBuildServerId(buildServerId);
        if (StringUtils.isBlank((CharSequence)callback)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.build.server.auth.callback.blank", new Object[0]));
        }
        URI baseUrl = this.applicationPropertiesService.getBaseUrl();
        if (baseUrl == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.server.auth.baseurl.invalid", new Object[0]));
        }
        String relativeCallbackPath = this.getRelativeCallback(callback, baseUrl.toString());
        return Response.temporaryRedirect((URI)this.buildServerAuthorizationService.getAuthorizationUrl(buildServerId, relativeCallbackPath)).build();
    }

    private void validateBuildServerId(String buildServerId) {
        if (StringUtils.isBlank((CharSequence)buildServerId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.build.server.auth.serverid.blank", new Object[0]));
        }
    }

    private String getRelativeCallback(String callback, String baseUrl) {
        String replaced = callback.replace(baseUrl, "");
        URI callbackUri = URI.create(replaced);
        if (callbackUri.isAbsolute()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.build.server.auth.callback.absolute", new Object[0]));
        }
        return replaced;
    }
}

