/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.operations;

import com.atlassian.bitbucket.dmz.build.operations.DmzBuildOperations;
import com.atlassian.bitbucket.internal.rest.build.operations.RestBuildAction;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import java.util.List;
import java.util.stream.Collectors;

public class RestBuildOperations
extends RestMapEntity {
    private static final String ACTIONS = "actions";
    private static final String IS_AUTHORIZATION_REQUIRED = "isAuthorizationRequired";
    private static final String PENDING_ACTION = "pending";

    public RestBuildOperations(DmzBuildOperations userCapabilities) {
        this.put(IS_AUTHORIZATION_REQUIRED, userCapabilities.isAuthorizationRequired());
        this.put(ACTIONS, userCapabilities.getActions().stream().map(RestBuildAction::new).collect(Collectors.toList()));
        this.putIfNotNull(PENDING_ACTION, userCapabilities.getPendingAction().map(RestBuildAction::new).orElse(null));
    }

    public RestBuildOperations() {
    }

    public boolean isAuthorizationRequired() {
        return this.getBoolProperty(IS_AUTHORIZATION_REQUIRED);
    }

    public List<RestBuildAction> getOperations() {
        return RestBuildOperations.transform((Iterable)((Iterable)this.get(ACTIONS)), RestBuildAction::valueOf);
    }

    public RestBuildAction getPendingAction() {
        return RestBuildAction.valueOf(this.get(PENDING_ACTION));
    }
}

