/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.auth.websudo;

import com.atlassian.bitbucket.dmz.auth.websudo.BitbucketWebSudoManager;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.google.common.collect.ImmutableMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@LicensedOnly
@Path(value="/websudo-session")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class WebSudoSessionResource {
    private final BitbucketWebSudoManager webSudoManager;

    @Inject
    public WebSudoSessionResource(BitbucketWebSudoManager webSudoManager) {
        this.webSudoManager = webSudoManager;
    }

    @GET
    public Response getExpiry(@Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) {
        return this.webSudoManager.getWebSudoSessionExpiry(servletRequest).map(expiry -> Response.ok((Object)ImmutableMap.builder().put((Object)"expiry", (Object)expiry.toEpochMilli()).build()).build()).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @PUT
    public Response refreshWebSudoSession(@Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) {
        this.webSudoManager.willExecuteWebSudoRequest(servletRequest);
        return this.getExpiry(servletRequest, servletResponse);
    }

    @DELETE
    public Response removeWebSudoSession(@Context HttpServletRequest servletRequest) {
        this.webSudoManager.removeWebSudoSession(servletRequest);
        return Response.noContent().build();
    }
}

