/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshController;
import com.atlassian.bitbucket.internal.rest.OptionalServiceRegistry;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/git/mesh/config")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class MeshConfigResource {
    private final OptionalServiceRegistry optionalServiceRegistry;

    @Inject
    public MeshConfigResource(OptionalServiceRegistry optionalServiceRegistry) {
        this.optionalServiceRegistry = optionalServiceRegistry;
    }

    @POST
    @Path(value="refresh")
    public Response refresh() {
        return this.ifAvailable(controller -> {
            controller.refreshConfiguration();
            return ResponseFactory.ok();
        });
    }

    private Response ifAvailable(Function<DmzMeshController, Response.ResponseBuilder> callback) {
        return this.optionalServiceRegistry.getMeshController().map(callback).orElse(ResponseFactory.notFound()).build();
    }
}

