/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.bitbucket.dmz.user.DmzCsvExportService;
import com.atlassian.bitbucket.util.ContentDispositionUtils;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/permissions")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class InternalGlobalPermissionResource {
    private final DmzCsvExportService csvExportService;

    @Inject
    public InternalGlobalPermissionResource(DmzCsvExportService csvExportService) {
        this.csvExportService = csvExportService;
    }

    @GET
    @Path(value="users/export")
    public Response exportUserPermissions() {
        String date = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss'Z'").format(LocalDateTime.now(ZoneId.of("UTC")));
        String fileName = String.format("user-permissions-%s.csv", date);
        String contentDisposition = ContentDispositionUtils.buildHeaderValue((ContentDispositionUtils.DispositionType)ContentDispositionUtils.DispositionType.ATTACHMENT, (String)fileName, (Instant)Instant.now());
        return Response.ok(arg_0 -> ((DmzCsvExportService)this.csvExportService).exportPermissionsToCsv(arg_0)).type("text/csv").header("Content-Disposition", (Object)contentDisposition).build();
    }
}

