/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.user;

import com.atlassian.bitbucket.rest.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.user.RestPerson;
import com.atlassian.bitbucket.rest.util.RestRelatedLinks;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=ApplicationUser.class)
public class RestApplicationUser
extends RestPerson
implements ApplicationUser {
    public static final Function<ApplicationUser, RestApplicationUser> REST_TRANSFORM = RestApplicationUser::new;
    private static final String ACTIVE = "active";
    private static final String DISPLAY_NAME = "displayName";
    private static final String EMAIL_ADDRESS = "emailAddress";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String SLUG = "slug";
    private static final String TYPE = "type";

    public RestApplicationUser(ApplicationUser user) {
        super((Person)user);
        this.put(ACTIVE, user.isActive());
        this.put(DISPLAY_NAME, user.getDisplayName());
        this.put(EMAIL_ADDRESS, user.getEmailAddress());
        this.put(ID, user.getId());
        this.put(NAME, user.getName());
        this.put(SLUG, user.getSlug());
        this.put(TYPE, user.getType().name());
    }

    protected RestApplicationUser() {
    }

    protected RestApplicationUser(Map<String, Object> map) {
        super(map);
    }

    public <T> T accept(@Nonnull ApplicationUserVisitor<T> visitor) {
        return (T)visitor.visit((ApplicationUser)this);
    }

    @Schema(example="Jane Citizen")
    @Nonnull
    public String getDisplayName() {
        return this.getStringProperty(DISPLAY_NAME);
    }

    @Override
    @Schema(example="jane@example.com")
    @Nullable
    public String getEmailAddress() {
        return this.getStringProperty(EMAIL_ADDRESS);
    }

    @Schema(example="101", accessMode=Schema.AccessMode.READ_ONLY)
    public int getId() {
        return this.getIntProperty(ID);
    }

    @Override
    @Schema(example="jcitizen")
    @Nonnull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Schema(example="jcitizen")
    @Nonnull
    public String getSlug() {
        return this.getStringProperty(SLUG);
    }

    @Nonnull
    public UserType getType() {
        return (UserType)this.getEnumProperty(TYPE, UserType.class);
    }

    public boolean isActive() {
        return this.getBoolProperty(ACTIVE);
    }

    public void setLinks(RestRelatedLinks links) {
        RestLinkedMapEntity.setLinks(this, links);
    }

    @Nullable
    public static RestApplicationUser valueOf(@Nullable Object value) {
        if (value instanceof RestApplicationUser) {
            return (RestApplicationUser)value;
        }
        if (value instanceof Map) {
            return new RestApplicationUser((Map)value);
        }
        return null;
    }
}

