/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull;

import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=PullRequestRef.class)
public class RestPullRequestRef
extends RestMapEntity {
    private static final String ID = "id";
    private static final String DISPLAY_ID = "displayId";
    private static final String LATEST_COMMIT = "latestCommit";
    private static final String REPOSITORY = "repository";
    private static final String TYPE = "type";

    public RestPullRequestRef(PullRequestRef ref) {
        this(ref.getId(), ref.getDisplayId(), ref.getLatestCommit(), ref.getType(), new RestRepository(ref.getRepository(), true));
    }

    public RestPullRequestRef(String refId, String displayId, String latestCommit, RestRepository repository) {
        this(refId, displayId, latestCommit, null, repository);
    }

    public RestPullRequestRef(String refId, String displayId, String latestCommit, RefType type, RestRepository repository) {
        this.put(ID, refId);
        this.putIfNotNull(DISPLAY_ID, displayId);
        this.putIfNotNull(LATEST_COMMIT, latestCommit);
        this.putIfNotNull(TYPE, type);
        this.put(REPOSITORY, (Object)repository);
    }

    private RestPullRequestRef(Map<String, Object> values) {
        super(values);
    }

    public RestRepository getRepository() {
        return RestRepository.valueOf(this.get(REPOSITORY));
    }

    @Schema(example="refs/heads/feature-ABC-123")
    @Nonnull
    public String getId() {
        return this.getStringProperty(ID);
    }

    @Schema(example="feature-ABC-1233")
    @Nonnull
    public String getDisplayId() {
        return this.getStringProperty(DISPLAY_ID);
    }

    @Schema(example="babecafebabecafebabecafebabecafebabecafe")
    @Nonnull
    public String getLatestCommit() {
        return this.getStringProperty(LATEST_COMMIT);
    }

    public StandardRefType getType() {
        return (StandardRefType)this.getEnumProperty(TYPE, StandardRefType.class);
    }

    @Nullable
    public static RestPullRequestRef valueOf(@Nullable Object value) {
        if (value instanceof RestPullRequestRef) {
            return (RestPullRequestRef)((Object)value);
        }
        if (value instanceof Map) {
            return new RestPullRequestRef((Map)value);
        }
        return null;
    }
}

