/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull;

import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.rest.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.pull.RestPullRequestParticipant;
import com.atlassian.bitbucket.rest.pull.RestPullRequestRef;
import com.atlassian.bitbucket.rest.util.RestNamedLink;
import com.atlassian.bitbucket.rest.util.RestRelatedLinks;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=PullRequest.class)
public class RestPullRequest
extends RestLinkedMapEntity {
    public static final String AUTHOR = "author";
    public static final String CLOSED = "closed";
    public static final String CLOSED_DATE = "closedDate";
    public static final String CREATED_DATE = "createdDate";
    public static final String DESCRIPTION = "description";
    public static final String DESCRIPTION_AS_HTML = "descriptionAsHtml";
    public static final String DRAFT = "draft";
    public static final String FROM_REF = "fromRef";
    public static final String ID = "id";
    public static final String LOCKED = "locked";
    public static final String OPEN = "open";
    public static final String PARTICIPANTS = "participants";
    public static final String REVIEWERS = "reviewers";
    public static final String STATE = "state";
    public static final String TITLE = "title";
    public static final String TO_REF = "toRef";
    public static final String UPDATED_DATE = "updatedDate";
    public static final String VERSION = "version";
    public static final Function<PullRequest, RestPullRequest> REST_TRANSFORM = RestPullRequest::new;

    public RestPullRequest() {
    }

    public RestPullRequest(PullRequest pullRequest) {
        this(pullRequest.getId(), pullRequest.getVersion(), pullRequest.getTitle(), pullRequest.getDescription(), pullRequest.getState(), pullRequest.getCreatedDate(), pullRequest.getUpdatedDate(), pullRequest.getClosedDate(), new RestPullRequestRef(pullRequest.getFromRef()), new RestPullRequestRef(pullRequest.getToRef()), pullRequest.isLocked(), new RestPullRequestParticipant(pullRequest.getAuthor()), RestPullRequest.getRestParticipants(pullRequest.getReviewers()), RestPullRequest.getRestParticipants(pullRequest.getParticipants()), pullRequest.getProperties(), null, pullRequest.isDraft());
    }

    private RestPullRequest(Map<String, Object> values) {
        super(values);
    }

    private RestPullRequest(long id, int version, String title, String description, PullRequestState state, Date created, Date updated, Date closed, RestPullRequestRef from, RestPullRequestRef to, Boolean locked, RestPullRequestParticipant author, Set<RestPullRequestParticipant> reviewers, Set<RestPullRequestParticipant> participants, PropertyMap properties, RestNamedLink selfLink, boolean draft) {
        if (id > 0L) {
            this.put(ID, id);
        }
        if (version != -1) {
            this.put(VERSION, version);
        }
        this.putIfNotNull(TITLE, title);
        this.putIfNotNull(DESCRIPTION, description);
        if (state != null) {
            this.put(STATE, state);
            this.put(OPEN, state == PullRequestState.OPEN);
            this.put(CLOSED, state != PullRequestState.OPEN);
        }
        this.put(DRAFT, draft);
        this.putIfNotNull(CREATED_DATE, created);
        this.putIfNotNull(UPDATED_DATE, updated);
        this.putIfNotNull(CLOSED_DATE, closed);
        this.putIfNotNull(FROM_REF, (Object)from);
        this.putIfNotNull(TO_REF, (Object)to);
        this.putIfNotNull(LOCKED, locked);
        this.putIfNotNull(AUTHOR, (Object)author);
        this.putIfNotNull(REVIEWERS, reviewers);
        this.putIfNotNull(PARTICIPANTS, participants);
        this.putIfNotEmpty("properties", (Map)properties);
        if (selfLink != null) {
            this.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", selfLink).build());
        }
    }

    @Schema(example="It is a kludge, but put the tuple from the database in the cache.")
    public String getDescription() {
        return StringUtils.trimToNull((String)this.getStringProperty(DESCRIPTION));
    }

    @Schema(example="1")
    public long getId() {
        return this.getLongProperty(ID);
    }

    public RestPullRequestRef getFromRef() {
        return RestPullRequestRef.valueOf(this.get(FROM_REF));
    }

    @ArraySchema(schema=@Schema(implementation=RestPullRequestParticipant.class))
    public Set<RestPullRequestParticipant> getReviewers() {
        return this.getParticipants(REVIEWERS);
    }

    @ArraySchema(schema=@Schema(implementation=RestPullRequestParticipant.class))
    public Set<RestPullRequestParticipant> getParticipants() {
        return this.getParticipants(PARTICIPANTS);
    }

    @Schema(example="Talking Nerdy")
    public String getTitle() {
        return StringUtils.trimToNull((String)this.getStringProperty(TITLE));
    }

    public RestPullRequestRef getToRef() {
        return RestPullRequestRef.valueOf(this.get(TO_REF));
    }

    public int getVersion() {
        return this.getIntProperty(VERSION);
    }

    @Schema(example="19990759200")
    public long getClosedDate() {
        return this.getLongProperty(CLOSED_DATE);
    }

    @Schema(example="13590759200")
    public long getCreatedDate() {
        return this.getLongProperty(CREATED_DATE);
    }

    @Schema(example="14490759200")
    public long getUpdatedDate() {
        return this.getLongProperty(UPDATED_DATE);
    }

    public PullRequestState getState() {
        return (PullRequestState)this.getEnumProperty(STATE, PullRequestState.class);
    }

    public boolean isLocked() {
        return this.getBoolProperty(LOCKED);
    }

    public boolean isClosed() {
        return this.getBoolProperty(CLOSED);
    }

    public boolean isDraft() {
        return this.getBoolProperty(DRAFT);
    }

    public boolean isOpen() {
        return this.getBoolProperty(OPEN);
    }

    public boolean hasAuthor() {
        return this.containsKey(AUTHOR);
    }

    public boolean hasDescription() {
        return this.getStringProperty(DESCRIPTION) != null;
    }

    public boolean hasDraft() {
        return this.containsKey(DRAFT);
    }

    public boolean hasParticipants() {
        return this.containsKey(PARTICIPANTS);
    }

    public boolean hasReviewers() {
        return this.containsKey(REVIEWERS);
    }

    public boolean hasTitle() {
        return this.getTitle() != null;
    }

    public boolean hasVersion() {
        return this.containsKey(VERSION);
    }

    public void setHtmlDescription(String html) {
        this.put(DESCRIPTION_AS_HTML, html);
    }

    @Nullable
    public static RestPullRequest valueOf(@Nullable Object value) {
        if (value instanceof RestPullRequest) {
            return (RestPullRequest)((Object)value);
        }
        if (value instanceof Map) {
            return new RestPullRequest((Map)value);
        }
        return null;
    }

    private Set<RestPullRequestParticipant> getParticipants(String key) {
        Collection<Object> rawReviewers;
        Object value = this.get(key);
        Collection<Object> collection = rawReviewers = value instanceof Collection ? (Collection)value : Collections.emptySet();
        if (!rawReviewers.isEmpty()) {
            HashSet<RestPullRequestParticipant> reviewers = new HashSet<RestPullRequestParticipant>(rawReviewers.size());
            for (Object rawReviewer : rawReviewers) {
                RestPullRequestParticipant reviewer = RestPullRequestParticipant.valueOf(rawReviewer);
                if (reviewer == null) continue;
                reviewers.add(reviewer);
            }
            return reviewers;
        }
        return Collections.emptySet();
    }

    private static Set<RestPullRequestParticipant> getRestParticipants(Set<PullRequestParticipant> participants) {
        return RestPullRequest.transform(participants, RestPullRequestParticipant.REST_TRANSFORM);
    }
}

