/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.project;

import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.rest.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.avatar.AvatarAware;
import com.atlassian.bitbucket.rest.project.RestPersonalProject;
import com.atlassian.bitbucket.scope.ScopeType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=Project.class)
public class RestProject
extends RestLinkedMapEntity
implements AvatarAware,
Project {
    public static final Function<Project, RestProject> REST_TRANSFORM = RestProject::fromProject;
    public static final ProjectVisitor<RestProject> TRANSFORM_VISITOR = new ProjectVisitor<RestProject>(){

        public RestProject visit(@Nonnull Project project) {
            return new RestProject(project);
        }

        public RestProject visit(@Nonnull PersonalProject project) {
            return new RestPersonalProject(project);
        }
    };
    private static final String AVATAR = "avatar";
    private static final String DESCRIPTION = "description";
    private static final String ID = "id";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String NAMESPACE = "namespace";
    private static final String PUBLIC = "public";
    private static final String TYPE = "type";
    private static final String SCOPE = "scope";

    public RestProject() {
    }

    public RestProject(Project project) {
        this(project.getId(), project.getKey(), project.getName(), project.getDescription(), project.getType(), project.isPublic());
    }

    @Deprecated
    RestProject(int id, String namespace, String key, String name, String description, ProjectType type, Boolean publiclyAccessible) {
        this(id, key, name, description, type, publiclyAccessible);
        this.putIfNotNull(NAMESPACE, namespace);
    }

    RestProject(int id, String key, String name, String description, ProjectType type, Boolean publiclyAccessible) {
        this.putIfNotNull(KEY, key);
        if (id > 0) {
            this.put(ID, id);
        }
        this.putIfNotNull(NAME, name);
        this.putIfNotNull(DESCRIPTION, description);
        this.putIfNotNull(PUBLIC, publiclyAccessible);
        if (type != null) {
            this.put(TYPE, type.name());
        }
    }

    private RestProject(Map<String, Object> values) {
        super(values);
    }

    public <T> T accept(@Nonnull ProjectVisitor<T> visitor) {
        return (T)visitor.visit((Project)this);
    }

    public String getAvatar() {
        return StringUtils.trimToNull((String)this.getStringProperty(AVATAR));
    }

    @Schema(example="The description for my cool project", accessMode=Schema.AccessMode.READ_ONLY)
    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public int getId() {
        return this.getIntProperty(ID);
    }

    @Schema(example="PRJ", required=true)
    @Nonnull
    public String getKey() {
        return this.getStringProperty(KEY);
    }

    @Schema(example="My Cool Project", accessMode=Schema.AccessMode.READ_ONLY)
    @Nonnull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Deprecated
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, deprecated=true)
    public String getNamespace() {
        return this.getStringProperty(NAMESPACE);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Nonnull
    public ProjectType getType() {
        return (ProjectType)this.getEnumProperty(TYPE, ProjectType.class);
    }

    @Schema(example="PROJECT", accessMode=Schema.AccessMode.READ_ONLY)
    public String getScope() {
        return this.getStringProperty(SCOPE);
    }

    public boolean hasAvatar() {
        return StringUtils.isNotBlank((CharSequence)this.getStringProperty(AVATAR));
    }

    public boolean hasPublic() {
        return this.get(PUBLIC) != null;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isPublic() {
        return this.getBoolProperty(PUBLIC);
    }

    @Override
    public void setAvatarUrl(String url) {
        this.put("avatarUrl", url);
    }

    public static RestProject fromProject(Project project) {
        if (project == null) {
            return null;
        }
        return (RestProject)project.accept(TRANSFORM_VISITOR);
    }

    public static RestProject simple(Project project) {
        if (project == null) {
            return null;
        }
        RestProject restProj = new RestProject();
        restProj.put(SCOPE, ScopeType.PROJECT.name());
        restProj.putIfNotNull(KEY, project.getKey());
        if (project.getId() > 0) {
            restProj.put(ID, project.getId());
        }
        restProj.putIfNotNull(NAME, project.getName());
        restProj.put(PUBLIC, project.isPublic());
        restProj.put(TYPE, project.getType().name());
        return restProj;
    }

    @Nullable
    public static RestProject valueOf(@Nullable Object value) {
        if (value instanceof RestProject) {
            return (RestProject)value;
        }
        if (value instanceof Map) {
            return new RestProject((Map)value);
        }
        return null;
    }
}

