/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.validation.groups.Create;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.URL;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=MeshNode.class)
public class RestMeshNode
extends RestMapEntity {
    public RestMeshNode() {
    }

    public RestMeshNode(MeshNode node) {
        this.put("id", node.getId());
        this.putIfNotNull("lastSeenDate", node.getLastSeenDate());
        this.put("name", node.getName());
        this.put("rpcId", node.getRpcId());
        this.put("rpcUrl", node.getRpcUrl());
        this.put("state", node.getState());
        this.put("offline", node.isOffline());
    }

    public RestMeshNode(Map<String, ?> sourceNode) {
        super(sourceNode);
    }

    @Schema(example="FALSE")
    public boolean isOffline() {
        return this.getBoolProperty("offline");
    }

    @Nonnull
    @Schema(example="1")
    public String getId() {
        return this.getStringProperty("id");
    }

    @Nullable
    @Schema(example="1630041546433", type="number")
    public Date getLastSeenDate() {
        return (Date)this.get("lastSeenDate");
    }

    @Nullable
    @Schema(example="My node")
    @OptionalString
    public String getName() {
        return this.getStringProperty("name");
    }

    @Nonnull
    @Schema(example="1")
    public String getRpcId() {
        return this.getStringProperty("rpcId");
    }

    @Nonnull
    @Schema(example="http://127.0.0.1:7999")
    @URL
    @RequiredString(groups={Create.class})
    public String getRpcUrl() {
        return this.getStringProperty("rpcUrl");
    }

    @Nullable
    @Schema(example="AVAILABLE")
    public MeshNode.State getState() {
        return (MeshNode.State)this.getEnumProperty("state", MeshNode.State.class);
    }

    public static RestMeshNode valueOf(Object value) {
        if (value instanceof RestMeshNode) {
            return (RestMeshNode)((Object)value);
        }
        if (value instanceof Map) {
            Map values = (Map)value;
            return new RestMeshNode(values);
        }
        return null;
    }
}

