/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.license;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.license.RestLicenseStatus;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=BitbucketServerLicense.class)
public class RestBitbucketLicense
extends RestMapEntity {
    private static final String CREATION_DATE = "creationDate";
    private static final String DAYS_BEFORE_EXPIRY = "numberOfDaysBeforeExpiry";
    private static final String DAYS_BEFORE_GRACE_PERIOD_EXPIRY = "numberOfDaysBeforeGracePeriodExpiry";
    private static final String DAYS_BEFORE_MAINTENANCE_EXPIRY = "numberOfDaysBeforeMaintenanceExpiry";
    private static final String EXPIRY_DATE = "expiryDate";
    private static final String GRACE_PERIOD_EXPIRY = "gracePeriodEndDate";
    private static final String LICENSE = "license";
    private static final String MAINTENANCE_EXPIRY = "maintenanceExpiryDate";
    private static final String MAXIMUM_NUMBER_OF_USERS = "maximumNumberOfUsers";
    private static final String PURCHASE_DATE = "purchaseDate";
    private static final String SEN = "supportEntitlementNumber";
    private static final String SERVER_ID = "serverId";
    private static final String STATUS = "status";
    private static final String UNLIMITED_NUMBER_OF_USERS = "unlimitedNumberOfUsers";

    public RestBitbucketLicense() {
    }

    public RestBitbucketLicense(BitbucketServerLicense license) {
        this.put(CREATION_DATE, license.getCreationDate());
        this.put(PURCHASE_DATE, license.getPurchaseDate());
        this.put(EXPIRY_DATE, license.getExpiryDate());
        this.put(DAYS_BEFORE_EXPIRY, license.getNumberOfDaysBeforeExpiry());
        this.put(MAINTENANCE_EXPIRY, license.getMaintenanceExpiryDate());
        this.put(DAYS_BEFORE_MAINTENANCE_EXPIRY, license.getNumberOfDaysBeforeMaintenanceExpiry());
        this.put(GRACE_PERIOD_EXPIRY, license.getGracePeriodEndDate());
        this.put(DAYS_BEFORE_GRACE_PERIOD_EXPIRY, license.getNumberOfDaysBeforeGracePeriodExpiry());
        this.put(MAXIMUM_NUMBER_OF_USERS, license.isUnlimitedNumberOfUsers() ? -1 : license.getMaximumNumberOfUsers());
        this.put(UNLIMITED_NUMBER_OF_USERS, license.isUnlimitedNumberOfUsers());
        this.put(SERVER_ID, license.getServerId());
        this.put(SEN, license.getSupportEntitlementNumber());
    }

    public RestBitbucketLicense(BitbucketServerLicense license, String encodedLicense, RestLicenseStatus status) {
        this(license);
        this.put(LICENSE, encodedLicense);
        this.put(STATUS, (Object)status);
    }

    @Schema(example="1331038800000", accessMode=Schema.AccessMode.READ_ONLY)
    @Nullable
    public Long getCreationDate() {
        Object date = this.get(CREATION_DATE);
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        return null;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public int getDaysBeforeExpiry() {
        return this.getIntProperty(DAYS_BEFORE_EXPIRY);
    }

    @Schema(example="1372493732817", accessMode=Schema.AccessMode.READ_ONLY)
    @Nullable
    public Long getExpiryDate() {
        Object date = this.get(EXPIRY_DATE);
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        return null;
    }

    @Schema(example="1372493732817", accessMode=Schema.AccessMode.READ_ONLY)
    @Nullable
    public Long getGracePeriodEndDate() {
        Object date = this.get(GRACE_PERIOD_EXPIRY);
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        return null;
    }

    @Schema(example="<encoded license text>")
    public String getLicense() {
        return this.getStringProperty(LICENSE);
    }

    @Schema(example="1372493732817", accessMode=Schema.AccessMode.READ_ONLY)
    @Nullable
    public Long getMaintenanceExpiryDate() {
        Object date = this.get(MAINTENANCE_EXPIRY);
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        return null;
    }

    @Schema(example="12", accessMode=Schema.AccessMode.READ_ONLY)
    public int getMaximumNumberOfUsers() {
        return this.getIntProperty(MAXIMUM_NUMBER_OF_USERS);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public int getNumberOfDaysBeforeExpiry() {
        return this.getIntProperty(DAYS_BEFORE_GRACE_PERIOD_EXPIRY);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public int getNumberOfDaysBeforeGracePeriodExpiry() {
        return this.getIntProperty(DAYS_BEFORE_GRACE_PERIOD_EXPIRY);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public int getNumberOfDaysBeforeMaintenanceExpiry() {
        return this.getIntProperty(DAYS_BEFORE_MAINTENANCE_EXPIRY);
    }

    @Schema(example="1331038800000", accessMode=Schema.AccessMode.READ_ONLY)
    @Nullable
    public Long getPurchaseDate() {
        Object date = this.get(PURCHASE_DATE);
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        return null;
    }

    @Schema(example="<server ID embedded in license>", accessMode=Schema.AccessMode.READ_ONLY)
    public String getServerId() {
        return this.getStringProperty(SERVER_ID);
    }

    @Schema(implementation=ExampleStatus.class, accessMode=Schema.AccessMode.READ_ONLY)
    public Map<String, Object> getStatus() {
        return (Map)this.get(STATUS);
    }

    @Schema(example="<support entitlement number embedded in license>", accessMode=Schema.AccessMode.READ_ONLY)
    public String getSupportEntitlementNumber() {
        return this.getStringProperty(SEN);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean getUnlimitedNumberOfUsers() {
        return this.getBoolProperty(UNLIMITED_NUMBER_OF_USERS);
    }

    private static class ExampleStatus {
        private ExampleStatus() {
        }

        @Schema(example="2")
        public int getCurrentNumberOfUsers() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(example="<actual server ID>")
        public String getServerId() {
            throw new RuntimeException("This method should not be invoked");
        }
    }
}

