/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.job;

import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.user.RestDetailedUser;
import com.atlassian.bitbucket.rest.util.RestProgress;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.ServiceUser;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=Job.class)
public class RestJob
extends RestMapEntity {
    public static final String ID = "id";
    public static final String END_DATE = "endDate";
    public static final String NODE_ID = "nodeId";
    public static final String PROGRESS = "progress";
    public static final String START_DATE = "startDate";
    public static final String STATE = "state";
    public static final String TYPE = "type";
    public static final String UPDATE_DATE = "updateDate";
    public static final String INITIATOR = "initiator";

    public RestJob(@Nonnull Job job) {
        Objects.requireNonNull(job, "job");
        this.putIfNotNull(END_DATE, job.getEndDate().map(Date::from).orElse(null));
        this.put(ID, job.getId());
        job.getInitiator().ifPresent(initiator -> this.put(INITIATOR, initiator.accept((ApplicationUserVisitor)new ApplicationUserVisitor<RestApplicationUser>(){

            public RestApplicationUser visit(@Nonnull DetailedUser user) {
                return new RestDetailedUser(user);
            }

            public RestApplicationUser visit(@Nonnull ServiceUser user) {
                return new RestApplicationUser((ApplicationUser)user);
            }

            public RestApplicationUser visit(@Nonnull ApplicationUser user) {
                return new RestApplicationUser(user);
            }
        })));
        this.put(NODE_ID, job.getNodeId());
        this.put(PROGRESS, (Object)new RestProgress(job.getProgress()));
        this.put(START_DATE, Date.from(job.getStartDate()));
        this.put(STATE, job.getState().name());
        this.put(TYPE, job.getType());
        this.put(UPDATE_DATE, Date.from(job.getUpdatedDate()));
    }

    @Schema(example="1")
    public long getId() {
        return this.getLongProperty(ID);
    }

    @Schema(example="1bec7499-077a-4b58-b27c-996a9c2187a4")
    public String getNodeId() {
        return this.getStringProperty(NODE_ID);
    }

    @Schema(example="1497657601000")
    public long getStartDate() {
        return this.getLongProperty(START_DATE);
    }

    @Schema(example="1497657603000")
    public long getEndDate() {
        return this.getLongProperty(END_DATE);
    }

    @Schema(example="1497657603000")
    public long getUpdatedDate() {
        return this.getLongProperty(UPDATE_DATE);
    }

    public RestProgress getProgress() {
        return (RestProgress)((Object)this.get(PROGRESS));
    }

    @Schema(example="com.atlassian.bitbucket.migration.export")
    public String getType() {
        return this.getStringProperty(TYPE);
    }

    public JobState getState() {
        return (JobState)this.getEnumProperty(STATE, JobState.class);
    }

    public RestApplicationUser getInitiator() {
        return (RestApplicationUser)this.get(INITIATOR);
    }
}

