/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.content;

import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.File;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.content.RestContentTreeNode;
import com.atlassian.bitbucket.rest.content.RestPath;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=File.class)
public class RestFile
extends RestMapEntity
implements RestContentTreeNode {
    private static final String CONTENT_ID = "contentId";
    private static final String PATH = "path";
    private static final String SIZE = "size";
    private static final String TYPE = "type";

    public RestFile(File file) {
        this(RestPath.fromPath((Path)file.getPath()), file.getContentId(), file.getSize());
    }

    private RestFile(RestPath path, String contentId, OptionalLong size) {
        this.put(PATH, path);
        this.put(CONTENT_ID, contentId);
        this.put(TYPE, ContentTreeNode.Type.FILE);
        size.ifPresent(value -> this.put(SIZE, value));
    }

    @Schema(example="addcbdab1ddd9245f97d4461f6bdf2c0f3724880")
    public String getContentId() {
        return this.getStringProperty(CONTENT_ID);
    }

    public RestPath getPath() {
        return (RestPath)this.get(PATH);
    }

    @Schema(example="24067")
    @Nullable
    public Long getSize() {
        long size = this.getLongProperty(SIZE);
        if (size == -1L) {
            return null;
        }
        return size;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY, example="FILE")
    public ContentTreeNode.Type getType() {
        return (ContentTreeNode.Type)this.getEnumProperty(TYPE, ContentTreeNode.Type.class);
    }
}

