/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.content;

import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffLine;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.function.Function;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=DiffLine.class)
public class RestDiffLine
extends RestMapEntity {
    public static final Function<DiffLine, RestDiffLine> REST_TRANSFORM = RestDiffLine::new;
    private static final String DESTINATION = "destination";
    private static final String SOURCE = "source";
    private static final String LINE = "line";
    private static final String TRUNCATED = "repository";
    private static final String CONFLICTED_MARKER = "conflictedMarker";
    private static final String COMMENT_IDS = "commentIds";

    public RestDiffLine() {
    }

    public RestDiffLine(DiffLine line) {
        this(line.getSource(), line.getDestination(), line.getLine(), line.isConflicting(), line.getConflictMarker(), line.getCommentIds(), line.isTruncated());
    }

    private RestDiffLine(int source, int destination, String line, boolean conflicted, ConflictMarker conflictMarker, List<Long> commentIds, boolean truncated) {
        this.putIfNotNull(DESTINATION, destination);
        this.putIfNotNull(SOURCE, source);
        this.putIfNotNull(LINE, line);
        this.putIfNotNull(TRUNCATED, truncated);
        if (conflicted) {
            this.put(CONFLICTED_MARKER, conflictMarker);
        }
        this.putIfNotEmpty(COMMENT_IDS, commentIds);
    }

    public int getSource() {
        return this.getIntProperty(SOURCE);
    }

    public int getDestination() {
        return this.getIntProperty(DESTINATION);
    }

    public String getLine() {
        return this.getStringProperty(LINE);
    }

    public ConflictMarker getConflictMarker() {
        return (ConflictMarker)this.getEnumProperty(CONFLICTED_MARKER, ConflictMarker.class);
    }

    @ArraySchema(schema=@Schema(implementation=Long.class))
    public List<Long> getCommentIds() {
        return (List)this.get(COMMENT_IDS);
    }

    public boolean isTruncated() {
        return this.getBoolProperty(TRUNCATED);
    }
}

