/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.content;

import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.comment.RestComment;
import com.atlassian.bitbucket.rest.content.RestDiffHunk;
import com.atlassian.bitbucket.rest.content.RestPath;
import com.atlassian.bitbucket.rest.property.RestPropertySupport;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.util.MoreStreams;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=Diff.class)
public class RestDiff
extends RestPropertySupport {
    public static final Function<Diff, RestDiff> REST_TRANSFORM = RestDiff::new;
    private static final String SOURCE = "source";
    private static final String DESTINATION = "destination";
    private static final String BINARY = "binary";
    private static final String HUNKS = "hunks";
    private static final String LINE_COMMENTS = "lineComments";
    private static final String TRUNCATED = "truncated";

    public RestDiff() {
    }

    public RestDiff(Diff diff) {
        this(RestPath.fromPath((Path)diff.getSource()), RestPath.fromPath((Path)diff.getDestination()), diff.isBinary(), diff.isBinary() ? null : RestDiff.transform((Iterable)diff.getHunks(), RestDiffHunk.REST_TRANSFORM), null, diff.isTruncated(), diff.getProperties());
    }

    private RestDiff(RestPath source, RestPath destination, boolean isBinary, Iterable<RestDiffHunk> hunks, Iterable<RestComment> lineComments, boolean isTruncated, PropertyMap properties) {
        this.put(SOURCE, source);
        this.put(DESTINATION, destination);
        if (isBinary) {
            this.put(BINARY, true);
        } else {
            this.put(HUNKS, hunks);
            this.putIfNotEmpty(LINE_COMMENTS, lineComments);
            this.putIfNotNull(TRUNCATED, isTruncated);
            this.putProperties((Map<String, Object>)properties);
        }
    }

    public RestPath getSource() {
        return (RestPath)this.get(SOURCE);
    }

    public RestPath getDestination() {
        return (RestPath)this.get(DESTINATION);
    }

    @ArraySchema(schema=@Schema(implementation=RestDiffHunk.class))
    @Nonnull
    public Set<RestDiffHunk> getHunks() {
        Iterable hunks = (Iterable)this.get(HUNKS);
        if (hunks == null) {
            return Collections.emptySet();
        }
        return MoreStreams.streamIterable((Iterable)hunks).map(hunk -> {
            if (hunk instanceof RestDiffHunk) {
                return (RestDiffHunk)((Object)((Object)hunk));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @ArraySchema(schema=@Schema(implementation=RestComment.class))
    @Nonnull
    public Set<RestComment> getLineComments() {
        Iterable comments = (Iterable)this.get(LINE_COMMENTS);
        if (comments == null) {
            return Collections.emptySet();
        }
        return MoreStreams.streamIterable((Iterable)comments).map(comment -> {
            if (comment instanceof RestComment) {
                return (RestComment)((Object)((Object)comment));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean isBinary() {
        return this.getBoolProperty(BINARY);
    }

    public boolean isTruncated() {
        return this.getBoolProperty(TRUNCATED);
    }

    public boolean hasHunks() {
        return this.containsKey(HUNKS);
    }

    private static <T extends RestMapEntity> T enrichTopLevel(T entity) {
        return RestDocUtils.decorate(entity, ImmutableMap.of((Object)TRUNCATED, (Object)"true", (Object)"contextLines", (Object)"10", (Object)"fromHash", (Object)"a0f224fd7bd5f28ea5a752d41b9c9f6372fc6d9e", (Object)"toHash", (Object)"dc93f22caadcde35daf5cc2cd65d2738c87e31ca", (Object)"whiteSpace", (Object)"SHOW"));
    }
}

