/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.content;

import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.rest.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.content.RestConflict;
import com.atlassian.bitbucket.rest.content.RestPath;
import com.atlassian.bitbucket.rest.util.RestNamedLink;
import com.atlassian.bitbucket.rest.util.RestRelatedLinks;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=Change.class)
public class RestChange
extends RestLinkedMapEntity {
    public static final Function<Change, RestChange> REST_TRANSFORM = change -> change == null ? null : new RestChange((Change)change);
    private static final String CONTENT_ID = "contentId";
    private static final String FROM_CONTENT_ID = "fromContentId";
    private static final String PATH = "path";
    private static final String EXECUTABLE = "executable";
    private static final String PERCENT_UNCHANGED = "percentUnchanged";
    private static final String TYPE = "type";
    private static final String NODE_TYPE = "nodeType";
    private static final String SRC_PATH = "srcPath";
    private static final String SRC_EXECUTABLE = "srcExecutable";
    private static final String CONFLICT = "conflict";

    public RestChange(Change change) {
        this(change, null);
    }

    public RestChange(Change change, NavBuilder.Commit commitNav) {
        this(change.getContentId(), change.getFromContentId(), RestPath.fromPath((Path)change.getPath()), change.getExecutable(), RestPath.fromPath((Path)change.getSrcPath()), change.getSrcExecutable(), change.getType(), change.getNodeType(), change.getPercentUnchanged(), RestConflict.fromConflict(change.getConflict()), change.getProperties(), commitNav == null ? null : new RestNamedLink(commitNav.change(change.getPath()).buildAbsolute()));
    }

    private RestChange(String contentId, String fromContentId, RestPath path, Boolean executable, RestPath srcPath, Boolean srcExecutable, ChangeType type, ContentTreeNode.Type nodeType, int percentUnchanged, RestConflict conflict, PropertyMap properties, RestNamedLink selfLink) {
        this.put(CONTENT_ID, contentId);
        this.put(FROM_CONTENT_ID, fromContentId);
        this.put(PATH, path);
        this.putIfNotNull(EXECUTABLE, executable);
        this.put(PERCENT_UNCHANGED, percentUnchanged);
        this.put(TYPE, type);
        this.put(NODE_TYPE, nodeType);
        this.putIfNotNull(SRC_PATH, srcPath);
        this.putIfNotNull(SRC_EXECUTABLE, srcExecutable);
        this.putIfNotNull(CONFLICT, (Object)conflict);
        this.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", selfLink).build());
        this.putIfNotEmpty("properties", (Map)properties);
    }

    public static Function<Change, RestChange> transform() {
        return REST_TRANSFORM;
    }

    public static Function<Change, RestChange> transform(NavBuilder.Commit nav) {
        if (nav == null) {
            return RestChange.transform();
        }
        return change -> new RestChange((Change)change, nav);
    }

    public RestConflict getConflict() {
        return (RestConflict)((Object)this.get(CONFLICT));
    }

    @Schema(example="abcdef0123abcdef4567abcdef8987abcdef6543")
    public String getContentId() {
        return this.getStringProperty(CONTENT_ID);
    }

    @Nullable
    public Boolean getExecutable() {
        return (Boolean)this.get(EXECUTABLE);
    }

    @Schema(example="bcdef0123abcdef4567abcdef8987abcdef6543a")
    public String getFromContentId() {
        return this.getStringProperty(FROM_CONTENT_ID);
    }

    public ContentTreeNode.Type getNodeType() {
        return (ContentTreeNode.Type)this.get(NODE_TYPE);
    }

    public RestPath getPath() {
        return (RestPath)this.get(PATH);
    }

    @Schema(example="98")
    public int getPercentUnchanged() {
        return this.getIntProperty(PERCENT_UNCHANGED);
    }

    @Nullable
    public Boolean getSrcExecutable() {
        return (Boolean)this.get(SRC_EXECUTABLE);
    }

    public RestPath getSrcPath() {
        return (RestPath)this.get(SRC_PATH);
    }

    public ChangeType getType() {
        return (ChangeType)this.getEnumProperty(TYPE, ChangeType.class);
    }
}

