/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.commit;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.commit.RestMinimalCommit;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.user.RestPerson;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.google.common.collect.ImmutableList;
import com.sun.jersey.spi.container.ContainerRequest;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=Commit.class)
public class RestCommit
extends RestMinimalCommit {
    public static final Function<Commit, RestCommit> REST_TRANSFORM = RestCommit::new;
    private static final String AUTHOR = "author";
    private static final String AUTHOR_TIMESTAMP = "authorTimestamp";
    private static final String COMMITTER = "committer";
    private static final String COMMITTER_TIMESTAMP = "committerTimestamp";
    private static final String MESSAGE = "message";
    private static final String PARENTS = "parents";
    private static final String PROPERTIES = "properties";

    public RestCommit(Commit commit) {
        this(commit.getId(), commit.getDisplayId(), RestPerson.REST_TRANSFORM.apply(commit.getAuthor()), commit.getAuthorTimestamp(), RestPerson.REST_TRANSFORM.apply(commit.getCommitter()), commit.getCommitterTimestamp(), commit.getMessage(), (Collection<RestMinimalCommit>)ImmutableList.copyOf((Collection)RestMapEntity.transform((Iterable)commit.getParents(), RestMinimalCommit.REST_TRANSFORM)), (Map<String, Object>)commit.getProperties());
    }

    private RestCommit(Map<String, Object> values) {
        super(values);
    }

    private RestCommit(String id, String displayId, RestPerson author, Date authorTimestamp, RestPerson committer, Date committerTimestamp, String message, Collection<RestMinimalCommit> parents, Map<String, Object> properties) {
        super(id, displayId);
        this.put(AUTHOR, author);
        this.put(AUTHOR_TIMESTAMP, authorTimestamp);
        this.put(COMMITTER, committer);
        this.put(COMMITTER_TIMESTAMP, committerTimestamp);
        this.put(MESSAGE, message);
        this.put(PARENTS, parents);
        this.putIfNotEmpty(PROPERTIES, properties);
    }

    public RestPerson getAuthor() {
        return (RestPerson)this.get(AUTHOR);
    }

    @Schema(example="1359075920")
    public long getAuthorTimestamp() {
        return this.getLongProperty(AUTHOR_TIMESTAMP);
    }

    public RestPerson getCommitter() {
        return (RestPerson)this.get(COMMITTER);
    }

    @Schema(example="1449075830")
    public long getCommitterTimestamp() {
        return this.getLongProperty(COMMITTER_TIMESTAMP);
    }

    @Schema(example="More work on feature 1")
    public String getMessage() {
        return this.getStringProperty(MESSAGE);
    }

    @ArraySchema(schema=@Schema(implementation=RestMinimalCommit.class))
    public Collection<RestMinimalCommit> getParents() {
        return (Collection)this.get(PARENTS);
    }

    public static Function<Commit, RestCommit> createTransformer(@Nonnull ContainerRequest request, @Nonnull AvatarEnricher avatarEnricher) {
        AvatarRequest avatarRequest = RestUtils.makeAvatarRequest((ContainerRequest)request);
        if (avatarRequest == null) {
            return REST_TRANSFORM;
        }
        return commit -> {
            RestCommit restCommit = new RestCommit((Commit)commit);
            avatarEnricher.enrich((Object)restCommit, avatarRequest);
            return restCommit;
        };
    }

    @Nullable
    public static RestCommit valueOf(Object value) {
        if (value instanceof RestCommit) {
            return (RestCommit)((Object)value);
        }
        if (value instanceof Map) {
            return new RestCommit((Map)value);
        }
        return null;
    }
}

