/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.comment;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.content.RestPath;
import com.atlassian.bitbucket.rest.pull.RestPullRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=CommentThreadDiffAnchor.class)
public class RestCommentThreadDiffAnchor
extends RestMapEntity {
    public static final Function<CommentThreadDiffAnchor, RestCommentThreadDiffAnchor> REST_TRANSFORM = RestCommentThreadDiffAnchor::new;
    private static final String DIFF_TYPE = "diffType";
    private static final String LINE = "line";
    private static final String LINE_TYPE = "lineType";
    private static final String FILE_TYPE = "fileType";
    private static final String FROM_HASH = "fromHash";
    private static final String ORPHANED = "orphaned";
    private static final String PATH = "path";
    private static final String PULL_REQUEST = "pullRequest";
    private static final String SRC_PATH = "srcPath";
    private static final String TO_HASH = "toHash";

    public RestCommentThreadDiffAnchor() {
    }

    public RestCommentThreadDiffAnchor(Map<String, Object> values) {
        super(values);
    }

    public RestCommentThreadDiffAnchor(CommentThreadDiffAnchor anchor) {
        this(anchor.getFromHash().orElse(null), anchor.getToHash(), anchor.getPath(), anchor.getSrcPath().orElse(null), anchor.isLineAnchor() ? Integer.valueOf(anchor.getLine()) : null, anchor.getLineType().orElse(null), anchor.getFileType().orElse(null));
        this.put(DIFF_TYPE, anchor.getDiffType());
        this.put(ORPHANED, anchor.isOrphaned());
    }

    private RestCommentThreadDiffAnchor(String fromHash, String toHash, String path, String srcPath, Integer line, DiffSegmentType lineType, DiffFileType fileType) {
        this(fromHash, toHash, line, lineType, fileType);
        this.putIfNotNull(PATH, path);
        this.putIfNotNull(SRC_PATH, srcPath);
    }

    private RestCommentThreadDiffAnchor(String fromHash, String toHash, Integer line, DiffSegmentType lineType, DiffFileType fileType) {
        this.putIfNotNull(FROM_HASH, fromHash);
        this.putIfNotNull(TO_HASH, toHash);
        this.putIfNotNull(LINE, line);
        this.putIfNotNull(LINE_TYPE, lineType);
        this.putIfNotNull(FILE_TYPE, fileType);
    }

    private RestCommentThreadDiffAnchor(String fromHash, String toHash, Integer line, DiffSegmentType lineType, DiffFileType fileType, RestPullRequest pullRequest) {
        this.putIfNotNull(FROM_HASH, fromHash);
        this.putIfNotNull(TO_HASH, toHash);
        this.putIfNotNull(LINE, line);
        this.putIfNotNull(LINE_TYPE, lineType);
        this.putIfNotNull(FILE_TYPE, fileType);
        this.putIfNotNull(PULL_REQUEST, (Object)pullRequest);
    }

    public CommentThreadDiffAnchorType getDiffType() {
        return (CommentThreadDiffAnchorType)this.getEnumProperty(DIFF_TYPE, CommentThreadDiffAnchorType.class);
    }

    public DiffFileType getFileType() {
        return (DiffFileType)this.getEnumProperty(FILE_TYPE, DiffFileType.class);
    }

    @Schema(example="62a0505e8204115b8b9c8a95bfa264a8c0896a93")
    public String getFromHash() {
        return this.getStringProperty(FROM_HASH);
    }

    @Schema(example="98")
    public int getLine() {
        return this.getIntProperty(LINE);
    }

    public DiffSegmentType getLineType() {
        return (DiffSegmentType)this.getEnumProperty(LINE_TYPE, DiffSegmentType.class);
    }

    public RestPath getPath() {
        return this.getPathProperty(PATH);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Nullable
    public RestPullRequest getPullRequest() {
        return RestPullRequest.valueOf(this.get(PULL_REQUEST));
    }

    public RestPath getSrcPath() {
        return this.getPathProperty(SRC_PATH);
    }

    public boolean hasSrcPath() {
        return this.containsKey(SRC_PATH);
    }

    @Schema(example="3cdd5d19178a54d2e51b5098d43b57571241d0ab")
    public String getToHash() {
        return this.getStringProperty(TO_HASH);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isLineComment() {
        return this.containsKey(LINE) && this.containsKey(LINE_TYPE);
    }
}

