/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.build;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.build.RestTestResults;
import com.atlassian.bitbucket.rest.commit.RestCommit;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
public class RestBuildStatus
extends RestMapEntity {
    private static final String BUILD_NUMBER = "buildNumber";
    private static final String COMMIT = "commit";
    private static final String CREATED_DATE = "createdDate";
    private static final String DATE_ADDED = "dateAdded";
    private static final String DESCRIPTION = "description";
    private static final String DURATION = "duration";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String PARENT = "parent";
    private static final String REF = "ref";
    private static final String STATE = "state";
    private static final String TEST_RESULTS = "testResults";
    private static final String UPDATED_DATE = "updatedDate";
    private static final String URL = "url";

    public RestBuildStatus() {
    }

    public RestBuildStatus(Map<String, Object> value) {
        super(value);
    }

    public RestBuildStatus(String buildNumber, RestCommit commit, Date createdDate, String description, Long duration, String key, String name, String parent, String ref, BuildState state, RestTestResults testResults, Date updatedDate, String url) {
        this.put(CREATED_DATE, createdDate.getTime());
        this.put(DATE_ADDED, updatedDate.getTime());
        this.putIfNotNull(DESCRIPTION, description);
        this.put(KEY, key);
        this.put(STATE, state);
        this.putIfNotNull(NAME, name);
        this.put(UPDATED_DATE, updatedDate.getTime());
        this.put(URL, url);
        this.putIfNotNull(BUILD_NUMBER, buildNumber);
        this.putIfNotNull(COMMIT, (Object)commit);
        this.putIfNotNull(DURATION, duration);
        this.putIfNotNull(PARENT, parent);
        this.putIfNotNull(REF, ref);
        this.putIfNotNull(TEST_RESULTS, (Object)testResults);
    }

    public RestBuildStatus(RepositoryBuildStatus buildStatus, RestCommit commit) {
        this(buildStatus.getBuildNumber().orElse(null), commit, buildStatus.getCreatedDate(), buildStatus.getDescription().orElse(null), buildStatus.getDuration().orElse(null), buildStatus.getKey(), buildStatus.getName().orElse(null), buildStatus.getParent().orElse(null), buildStatus.getRef().orElse(null), buildStatus.getState(), buildStatus.getTestResults().map(RestTestResults::new).orElse(null), buildStatus.getUpdatedDate(), buildStatus.getUrl());
    }

    public static RestBuildStatus valueOf(Object value) {
        if (value instanceof RestBuildStatus) {
            return (RestBuildStatus)((Object)value);
        }
        if (value instanceof Map) {
            return new RestBuildStatus((Map)value);
        }
        return null;
    }

    @Schema(example="3")
    @Nullable
    public String getBuildNumber() {
        return this.getStringProperty(BUILD_NUMBER);
    }

    @Schema(example="1587533099278")
    public long getCreatedDate() {
        return this.getLongProperty(CREATED_DATE);
    }

    @Schema(example="A description of the build goes here")
    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    @Nullable
    public Long getDuration() {
        long duration = this.getLongProperty(DURATION);
        if (duration == -1L) {
            return null;
        }
        return duration;
    }

    @Schema(example="TEST-REP3")
    public String getKey() {
        return this.getStringProperty(KEY);
    }

    @Schema(example="Database Matrix Tests")
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Schema(example="TEST-REP")
    @Nullable
    public String getParent() {
        return this.getStringProperty(PARENT);
    }

    @Schema(example="refs/heads/master")
    public String getRef() {
        return this.getStringProperty(REF);
    }

    public BuildState getState() {
        return (BuildState)this.getEnumProperty(STATE, BuildState.class);
    }

    @Nullable
    public RestTestResults getTestResults() {
        Object value = this.get(TEST_RESULTS);
        if (value instanceof RestTestResults) {
            return (RestTestResults)((Object)value);
        }
        if (value instanceof Map) {
            return new RestTestResults((Map)value);
        }
        return null;
    }

    @Schema(example="1587533699278")
    public long getUpdatedDate() {
        return this.getLongProperty(UPDATED_DATE);
    }

    @Schema(example="https://bamboo.example.com/browse/TEST-REP3")
    public String getUrl() {
        return this.getStringProperty(URL);
    }
}

