/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.util;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.util.RestNamedLink;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestRelatedLinks
extends RestMapEntity {
    public static final String RELATIONSHIP_SELF = "self";
    public static final String RELATIONSHIP_CLONE = "clone";
    public static final String RELATIONSHIP_MIRROR_CLONE = "mirrorClone";

    private RestRelatedLinks(Map<String, Collection<RestNamedLink>> relations) {
        super(relations);
    }

    public static class Builder {
        private final Map<String, Collection<RestNamedLink>> relatedLinks = Maps.newHashMap();

        public Builder addRelatedLink(String relationship, RestNamedLink link) {
            Collection existing = this.relatedLinks.computeIfAbsent(relationship, namedLinks -> Sets.newHashSet());
            existing.add(link);
            return this;
        }

        public Builder addRelatedLinks(String relationship, Collection<RestNamedLink> links) {
            Collection existing = this.relatedLinks.computeIfAbsent(relationship, namedLinks -> Sets.newHashSet());
            existing.addAll(links);
            return this;
        }

        public RestRelatedLinks build() {
            return new RestRelatedLinks(this.relatedLinks);
        }
    }
}

