/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.util;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.util.NamedLink;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestNamedLink
extends RestMapEntity
implements NamedLink {
    public static final Function<NamedLink, RestNamedLink> REST_TRANSFORM = RestNamedLink::new;
    public static final String ATTR_HREF = "href";
    public static final String ATTR_NAME = "name";

    public RestNamedLink(@Nonnull String href) {
        this(href, null);
    }

    public RestNamedLink(@Nonnull String href, @Nullable String name) {
        this.put(ATTR_HREF, href);
        this.putIfNotNull(ATTR_NAME, name);
    }

    public RestNamedLink(@Nonnull NamedLink link) {
        this(link.getHref(), link.getName());
    }

    public RestNamedLink(@Nonnull Map<String, Object> map) {
        super(map);
    }

    @Nonnull
    public String getName() {
        return this.getStringProperty(ATTR_NAME);
    }

    @Nonnull
    public String getHref() {
        return this.getStringProperty(ATTR_HREF);
    }

    @Nullable
    public static RestNamedLink valueOf(@Nullable Object link) {
        if (link instanceof RestNamedLink) {
            return (RestNamedLink)((Object)link);
        }
        if (link instanceof NamedLink) {
            return new RestNamedLink((NamedLink)link);
        }
        if (link instanceof Map) {
            return new RestNamedLink((Map)link);
        }
        return null;
    }
}

