/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.ratelimit.RestTokenBucketSettings;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RestUserRateLimitSettings
extends RestMapEntity {
    @Deprecated
    public static final RestUserRateLimitSettings EXAMPLE_RESPONSE_SETTINGS = new Builder(RestApplicationUser.RESPONSE_EXAMPLE).withSettings(RestTokenBucketSettings.EXAMPLE).build();
    @Deprecated
    public static final RestUserRateLimitSettings EXAMPLE_RESPONSE_WHITELISTED = new Builder(RestApplicationUser.RESPONSE_EXAMPLE).whitelisted().build();
    @Deprecated
    public static final RestPage<RestUserRateLimitSettings> EXAMPLE_PAGE = RestDocUtils.pageOf(EXAMPLE_RESPONSE_SETTINGS, EXAMPLE_RESPONSE_WHITELISTED);
    public static final String SETTINGS = "settings";
    public static final String USER = "user";
    public static final String WHITELISTED = "whitelisted";

    public RestUserRateLimitSettings() {
    }

    @Deprecated
    public RestUserRateLimitSettings(RestApplicationUser user, RestTokenBucketSettings settings) {
        this.put(USER, user);
        this.put(SETTINGS, (Object)settings);
    }

    @Deprecated
    public RestUserRateLimitSettings(RestApplicationUser user, boolean whitelisted) {
        this.put(USER, user);
        this.put(WHITELISTED, whitelisted);
    }

    @Deprecated
    public RestUserRateLimitSettings(ApplicationUser user, TokenBucketSettings settings) {
        this(new RestApplicationUser(user), new RestTokenBucketSettings(settings));
    }

    @Deprecated
    public RestUserRateLimitSettings(ApplicationUser user, boolean whitelisted) {
        this(new RestApplicationUser(user), whitelisted);
    }

    public RestUserRateLimitSettings(@Nonnull UserRateLimitSettings userRateLimitSettings) {
        Objects.requireNonNull(userRateLimitSettings, "userRateLimitSettings");
        this.put(USER, new RestApplicationUser(userRateLimitSettings.getUser()));
        if (userRateLimitSettings.isWhitelisted()) {
            this.put(WHITELISTED, true);
        } else {
            this.put(SETTINGS, (Object)userRateLimitSettings.getSettings().map(RestTokenBucketSettings::new).get());
        }
    }

    private RestUserRateLimitSettings(Builder builder) {
        Preconditions.checkArgument((builder.whitelisted || builder.settings != null ? 1 : 0) != 0, (Object)"Either user is whitelisted or token bucket settings must be provided.");
        this.put(USER, builder.user);
        if (builder.whitelisted) {
            this.put(WHITELISTED, true);
        } else {
            this.put(SETTINGS, (Object)builder.settings);
        }
    }

    public RestTokenBucketSettings getSettings() {
        return RestTokenBucketSettings.valueOf(this.get(SETTINGS));
    }

    public RestApplicationUser getUser() {
        return RestApplicationUser.valueOf(this.get(USER));
    }

    public boolean hasSettings() {
        return this.get(SETTINGS) != null;
    }

    public boolean isWhitelisted() {
        return this.getBoolProperty(WHITELISTED);
    }

    public static class Builder {
        private final RestApplicationUser user;
        private RestTokenBucketSettings settings;
        private boolean whitelisted;

        public Builder(@Nonnull ApplicationUser user) {
            this.user = Objects.requireNonNull(user, RestUserRateLimitSettings.USER) instanceof RestApplicationUser ? (RestApplicationUser)user : new RestApplicationUser(user);
        }

        public RestUserRateLimitSettings build() {
            return new RestUserRateLimitSettings(this);
        }

        public Builder whitelisted() {
            this.whitelisted = true;
            return this;
        }

        public Builder withSettings(RestTokenBucketSettings settings) {
            this.settings = settings;
            return this;
        }

        public Builder withSettings(TokenBucketSettings settings) {
            this.settings = RestTokenBucketSettings.valueOf(settings);
            return this;
        }
    }
}

