/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull.reviewer;

import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.avatar.AvatarAware;
import com.atlassian.bitbucket.rest.scope.RestScope;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=ReviewerGroup.class)
public class RestReviewerGroup
extends RestMapEntity
implements ReviewerGroup,
AvatarAware {
    @Deprecated
    public static final RestReviewerGroup EXAMPLE = new RestReviewerGroup(1L, "name", null, RestScope.REPOSITORY_SCOPE_EXAMPLE, (Collection<RestApplicationUser>)ImmutableList.of((Object)RestApplicationUser.RESPONSE_EXAMPLE));
    @Deprecated
    public static final RestPage<RestReviewerGroup> PAGE_EXAMPLE = RestDocUtils.pageOf(EXAMPLE);
    private static final String DESCRIPTION = "description";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String REVIEWER_GROUP = "REVIEWER_GROUP";
    private static final String SCOPE = "scope";
    private static final String TYPE = "type";
    private static final String USERS = "users";

    public RestReviewerGroup(ReviewerGroup reviewerGroup) {
        this(reviewerGroup.getId(), reviewerGroup.getName(), reviewerGroup.getDescription(), new RestScope(reviewerGroup.getScope()), RestReviewerGroup.toRestUsers(reviewerGroup.getUsers()));
    }

    public RestReviewerGroup() {
    }

    private RestReviewerGroup(long id, String name, String description, RestScope scope, Collection<RestApplicationUser> users) {
        this.put(DESCRIPTION, description);
        this.put(ID, id);
        this.put(NAME, name);
        this.put(SCOPE, (Object)scope);
        this.put(TYPE, REVIEWER_GROUP);
        this.put(USERS, users);
    }

    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    public long getId() {
        return this.getLongProperty(ID);
    }

    @Nonnull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Nonnull
    public RestScope getScope() {
        return RestScope.valueOf(this.get(SCOPE));
    }

    @Nonnull
    public Set<ApplicationUser> getUsers() {
        Object users = this.get(USERS);
        if (!(users instanceof List)) {
            return Collections.emptySet();
        }
        return ((List)users).stream().map(RestApplicationUser::valueOf).collect(Collectors.toSet());
    }

    public boolean hasDescription() {
        return this.containsKey(DESCRIPTION);
    }

    public boolean hasName() {
        return this.containsKey(NAME);
    }

    @Override
    public void setAvatarUrl(String url) {
        this.put("avatarUrl", url);
    }

    private static List<RestApplicationUser> toRestUsers(Collection<ApplicationUser> users) {
        return users.stream().map(RestApplicationUser::new).collect(Collectors.toList());
    }
}

