/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull;

import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=PullRequestRef.class)
public class RestPullRequestRef
extends RestMapEntity {
    @Deprecated
    public static final RestPullRequestRef REQUEST_MASTER_EXAMPLE = new RestPullRequestRef("refs/heads/master", null, null, RestRepository.REQUEST_EXAMPLE_WITH_PROJECT);
    @Deprecated
    public static final RestPullRequestRef RESPONSE_MASTER_EXAMPLE = new RestPullRequestRef("refs/heads/master", "master", "cafebabecafebabecafebabecafebabecafebabe", (RefType)StandardRefType.BRANCH, RestRepository.RESPONSE_EXAMPLE);
    @Deprecated
    public static final RestPullRequestRef REQUEST_FEATURE_EXAMPLE = new RestPullRequestRef("refs/heads/feature-ABC-123", null, null, null, RestRepository.REQUEST_EXAMPLE_WITH_PROJECT);
    @Deprecated
    public static final RestPullRequestRef RESPONSE_FEATURE_EXAMPLE = new RestPullRequestRef("refs/heads/feature-ABC-123", "feature-ABC-123", "babecafebabecafebabecafebabecafebabecafe", (RefType)StandardRefType.BRANCH, RestRepository.RESPONSE_EXAMPLE);
    private static final String ID = "id";
    private static final String DISPLAY_ID = "displayId";
    private static final String LATEST_COMMIT = "latestCommit";
    private static final String REPOSITORY = "repository";
    private static final String TYPE = "type";

    public RestPullRequestRef(PullRequestRef ref) {
        this(ref.getId(), ref.getDisplayId(), ref.getLatestCommit(), ref.getType(), new RestRepository(ref.getRepository(), true));
    }

    public RestPullRequestRef(String refId, String displayId, String latestCommit, RestRepository repository) {
        this(refId, displayId, latestCommit, null, repository);
    }

    public RestPullRequestRef(String refId, String displayId, String latestCommit, RefType type, RestRepository repository) {
        this.put(ID, refId);
        this.putIfNotNull(DISPLAY_ID, displayId);
        this.putIfNotNull(LATEST_COMMIT, latestCommit);
        this.putIfNotNull(TYPE, type);
        this.put(REPOSITORY, (Object)repository);
    }

    private RestPullRequestRef(Map<String, Object> values) {
        super(values);
    }

    public RestRepository getRepository() {
        return RestRepository.valueOf(this.get(REPOSITORY));
    }

    @Nonnull
    public String getId() {
        return this.getStringProperty(ID);
    }

    @Nullable
    public static RestPullRequestRef valueOf(@Nullable Object value) {
        if (value instanceof RestPullRequestRef) {
            return (RestPullRequestRef)((Object)value);
        }
        if (value instanceof Map) {
            return new RestPullRequestRef((Map)value);
        }
        return null;
    }
}

