/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.migration;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.validation.RepositorySelectorValid;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@RepositorySelectorValid
public class RestRepositorySelector
extends RestMapEntity {
    public static final String PROJECT_KEY = "projectKey";
    public static final String SLUG = "slug";
    @Deprecated
    public static final RestRepositorySelector REQUEST_EXAMPLE = new RestRepositorySelector("PRJ", "my-repo");

    public RestRepositorySelector() {
    }

    public RestRepositorySelector(String projectKey, String slug) {
        this.put(PROJECT_KEY, projectKey);
        this.put(SLUG, slug);
    }

    public RestRepositorySelector(Map value) {
        super(value);
    }

    @RequiredString(message="{bitbucket.rest.migration.projectkey.required}")
    @Nonnull
    public String getProjectKey() {
        return this.getStringProperty(PROJECT_KEY);
    }

    @RequiredString(message="{bitbucket.rest.migration.repositoryslug.required}")
    @Nonnull
    public String getSlug() {
        return this.getStringProperty(SLUG);
    }

    @Nullable
    public static RestRepositorySelector valueOf(@Nullable Object value) {
        if (value instanceof RestRepositorySelector) {
            return (RestRepositorySelector)((Object)value);
        }
        if (value instanceof Map) {
            return new RestRepositorySelector((Map)value);
        }
        return null;
    }
}

