/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.job;

import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.user.RestDetailedUser;
import com.atlassian.bitbucket.rest.util.RestProgress;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.ServiceUser;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Job.class)
public class RestJob
extends RestMapEntity {
    public static final String ID = "id";
    public static final String END_DATE = "endDate";
    public static final String NODE_ID = "nodeId";
    public static final String PROGRESS = "progress";
    public static final String START_DATE = "startDate";
    public static final String STATE = "state";
    public static final String TYPE = "type";
    public static final String UPDATE_DATE = "updateDate";
    public static final String INITIATOR = "initiator";
    private static final Date RESPONSE_EXAMPLE_START_DATE = new Date(1497657601000L);
    private static final Date RESPONSE_EXAMPLE_UPDATED_DATE = new Date(1497657603000L);
    private static final Date RESPONSE_EXAMPLE_END_DATE = new Date(1497657603000L);
    private static final String RESPONSE_EXAMPLE_NODE_ID = "1bec7499-077a-4b58-b27c-996a9c2187a4";
    private static final String RESPONSE_EXAMPLE_TYPE_EXPORT = "com.atlassian.bitbucket.migration.export";
    private static final String RESPONSE_EXAMPLE_TYPE_IMPORT = "com.atlassian.bitbucket.migration.import";
    @Deprecated
    public static final RestJob RESPONSE_EXAMPLE_EXPORT = new RestJob(1L, null, "1bec7499-077a-4b58-b27c-996a9c2187a4", RestProgress.RESPONSE_EXAMPLE, RESPONSE_EXAMPLE_START_DATE, JobState.RUNNING, "com.atlassian.bitbucket.migration.export", RESPONSE_EXAMPLE_UPDATED_DATE, RestApplicationUser.RESPONSE_EXAMPLE);
    @Deprecated
    public static final RestJob RESPONSE_EXAMPLE_IMPORT = new RestJob(1L, null, "1bec7499-077a-4b58-b27c-996a9c2187a4", RestProgress.RESPONSE_EXAMPLE, RESPONSE_EXAMPLE_START_DATE, JobState.RUNNING, "com.atlassian.bitbucket.migration.import", RESPONSE_EXAMPLE_UPDATED_DATE, RestApplicationUser.RESPONSE_EXAMPLE);

    private RestJob(long id, Date endDate, String nodeId, RestProgress progress, Date startDate, JobState state, String type, Date updateDate, RestApplicationUser initiator) {
        this.put(ID, id);
        this.putIfNotNull(END_DATE, endDate);
        this.putIfNotNull(NODE_ID, nodeId);
        this.putIfNotNull(PROGRESS, (Object)progress);
        this.putIfNotNull(START_DATE, startDate);
        this.putIfNotNull(STATE, state != null ? state.name() : null);
        this.putIfNotNull(TYPE, type);
        this.putIfNotNull(UPDATE_DATE, updateDate);
        this.putIfNotNull(INITIATOR, initiator);
    }

    public RestJob(@Nonnull Job job) {
        Objects.requireNonNull(job, "job");
        this.putIfNotNull(END_DATE, job.getEndDate().map(Date::from).orElse(null));
        this.put(ID, job.getId());
        job.getInitiator().ifPresent(initiator -> this.put(INITIATOR, initiator.accept((ApplicationUserVisitor)new ApplicationUserVisitor<RestApplicationUser>(){

            public RestApplicationUser visit(@Nonnull DetailedUser user) {
                return new RestDetailedUser(user);
            }

            public RestApplicationUser visit(@Nonnull ServiceUser user) {
                return new RestApplicationUser((ApplicationUser)user);
            }

            public RestApplicationUser visit(@Nonnull ApplicationUser user) {
                return new RestApplicationUser(user);
            }
        })));
        this.put(NODE_ID, job.getNodeId());
        this.put(PROGRESS, (Object)new RestProgress(job.getProgress()));
        this.put(START_DATE, Date.from(job.getStartDate()));
        this.put(STATE, job.getState().name());
        this.put(TYPE, job.getType());
        this.put(UPDATE_DATE, Date.from(job.getUpdatedDate()));
    }
}

