/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.commit;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.commit.RestMinimalCommit;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.user.RestPerson;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Commit.class)
public class RestCommit
extends RestMinimalCommit {
    public static final Function<Commit, RestCommit> REST_TRANSFORM = RestCommit::new;
    @Deprecated
    public static final RestCommit EXAMPLE = new RestCommit("abcdef0123abcdef4567abcdef8987abcdef6543", "abcdef0123a", RestPerson.EXAMPLE, new Date(), RestPerson.EXAMPLE, new Date(), "WIP on feature 1", Lists.newArrayList((Object[])new RestMinimalCommit[]{RestMinimalCommit.EXAMPLE}), null);
    @Deprecated
    public static final RestCommit EXAMPLE_ALT = new RestCommit("def0123abcdef4567abcdef8987abcdef6543abc", "def0123abcd", RestPerson.EXAMPLE, new Date(), RestPerson.EXAMPLE, new Date(), "More work on feature 1", Lists.newArrayList((Object[])new RestMinimalCommit[]{RestMinimalCommit.EXAMPLE}), null);
    @Deprecated
    public static final RestPage<RestCommit> PAGE_EXAMPLE = RestDocUtils.decorate(RestDocUtils.pageOf(EXAMPLE_ALT), ImmutableMap.of((Object)"authorCount", (Object)1, (Object)"totalCount", (Object)1));

    public RestCommit(Commit commit) {
        this(commit.getId(), commit.getDisplayId(), RestPerson.REST_TRANSFORM.apply(commit.getAuthor()), commit.getAuthorTimestamp(), RestPerson.REST_TRANSFORM.apply(commit.getCommitter()), commit.getCommitterTimestamp(), commit.getMessage(), (Collection<RestMinimalCommit>)ImmutableList.copyOf((Collection)RestMapEntity.transform((Iterable)commit.getParents(), RestMinimalCommit.REST_TRANSFORM)), (Map<String, Object>)commit.getProperties());
    }

    private RestCommit(Map<String, Object> values) {
        super(values);
    }

    private RestCommit(String id, String displayId, RestPerson author, Date authorTimestamp, RestPerson committer, Date committerTimestamp, String message, Collection<RestMinimalCommit> parents, Map<String, Object> properties) {
        super(id, displayId);
        this.put("author", author);
        this.put("authorTimestamp", authorTimestamp);
        this.put("committer", committer);
        this.put("committerTimestamp", committerTimestamp);
        this.put("message", message);
        this.put("parents", parents);
        this.putIfNotEmpty("properties", properties);
    }

    public static Function<Commit, RestCommit> createTransformer(@Nonnull ContainerRequest request, @Nonnull AvatarEnricher avatarEnricher) {
        AvatarRequest avatarRequest = RestUtils.makeAvatarRequest((ContainerRequest)request);
        if (avatarRequest == null) {
            return REST_TRANSFORM;
        }
        return commit -> {
            RestCommit restCommit = new RestCommit((Commit)commit);
            avatarEnricher.enrich((Object)restCommit, avatarRequest);
            return restCommit;
        };
    }

    @Nullable
    public static RestCommit valueOf(Object value) {
        if (value instanceof RestCommit) {
            return (RestCommit)((Object)value);
        }
        if (value instanceof Map) {
            return new RestCommit((Map)value);
        }
        return null;
    }
}

