/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull;

import com.atlassian.bitbucket.rest.RestMapEntity;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestPullRequestMergeRequest
extends RestMapEntity {
    public static final RestPullRequestMergeRequest MERGE_REQUEST_EXAMPLE = new RestPullRequestMergeRequest(){
        {
            this.put(RestPullRequestMergeRequest.CONTEXT, Collections.emptyMap());
            this.put(RestPullRequestMergeRequest.AUTO_SUBJECT, "(Optional, 5.7+) true to prepend an auto-generated subject to the message (default), or false to use the message as-is");
            this.put(RestPullRequestMergeRequest.MESSAGE, "(Optional) A descriptive message for the merge commit");
            this.put(RestPullRequestMergeRequest.STRATEGY_ID, "(Optional) squash");
            this.put(RestPullRequestMergeRequest.VERSION, 1);
        }
    };
    private static final String AUTO_SUBJECT = "autoSubject";
    private static final String CONTEXT = "context";
    private static final String MESSAGE = "message";
    private static final String STRATEGY_ID = "strategyId";
    private static final String VERSION = "version";

    @Nonnull
    public Map<String, Object> getContext() {
        Map<String, Object> context = (Map<String, Object>)this.get(CONTEXT);
        if (context == null) {
            context = Collections.emptyMap();
        }
        return context;
    }

    @Nullable
    public String getMessage() {
        return this.getStringProperty(MESSAGE);
    }

    @Nullable
    public String getStrategyId() {
        return this.getStringProperty(STRATEGY_ID);
    }

    public int getVersion() {
        return this.getIntProperty(VERSION);
    }

    public boolean hasVersion() {
        return this.containsKey(VERSION);
    }

    public boolean isAutoSubject() {
        return !this.containsKey(MESSAGE) || this.getBoolProperty(AUTO_SUBJECT, true);
    }
}

